/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.LoggerFactory;

public class DeadLetterChannelReifier
extends ErrorHandlerReifier<DeadLetterChannelDefinition> {
    public DeadLetterChannelReifier(Route route, DeadLetterChannelDefinition definition) {
        super(route, definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((DeadLetterChannelDefinition)this.definition).getDeadLetterUri(), (String)"deadLetterUri", (Object)this);
        RedeliveryPolicy redeliveryPolicy = this.resolveRedeliveryPolicy((DeadLetterChannelDefinition)this.definition, this.camelContext);
        CamelLogger logger = this.resolveLogger((DeadLetterChannelDefinition)this.definition, this.camelContext);
        Processor deadLetterProcessor = this.createDeadLetterChannelProcessor(((DeadLetterChannelDefinition)this.definition).getDeadLetterUri());
        DeadLetterChannel answer = new DeadLetterChannel(this.camelContext, processor, logger, this.getProcessor(((DeadLetterChannelDefinition)this.definition).getOnRedeliveryProcessor(), ((DeadLetterChannelDefinition)this.definition).getOnRedeliveryRef()), redeliveryPolicy, deadLetterProcessor, ((DeadLetterChannelDefinition)this.definition).getDeadLetterUri(), this.parseBoolean(((DeadLetterChannelDefinition)this.definition).getDeadLetterHandleNewException(), true), this.parseBoolean(((DeadLetterChannelDefinition)this.definition).getUseOriginalMessage(), false), this.parseBoolean(((DeadLetterChannelDefinition)this.definition).getUseOriginalBody(), false), this.resolveRetryWhilePolicy((DeadLetterChannelDefinition)this.definition, this.camelContext), this.getExecutorService(((DeadLetterChannelDefinition)this.definition).getExecutorServiceBean(), ((DeadLetterChannelDefinition)this.definition).getExecutorServiceRef()), this.getProcessor(((DeadLetterChannelDefinition)this.definition).getOnPrepareFailureProcessor(), ((DeadLetterChannelDefinition)this.definition).getOnPrepareFailureRef()), this.getProcessor(((DeadLetterChannelDefinition)this.definition).getOnExceptionOccurredProcessor(), ((DeadLetterChannelDefinition)this.definition).getOnExceptionOccurredRef()));
        this.configure((ErrorHandler)answer);
        return answer;
    }

    private Predicate resolveRetryWhilePolicy(DeadLetterChannelDefinition definition, CamelContext camelContext) {
        Predicate answer = definition.getRetryWhilePredicate();
        if (answer == null && definition.getRetryWhileRef() != null) {
            Language bean = camelContext.resolveLanguage("bean");
            answer = bean.createPredicate(definition.getRetryWhileRef());
            answer.initPredicate(camelContext);
        }
        return answer;
    }

    private CamelLogger resolveLogger(DeadLetterChannelDefinition definition, CamelContext camelContext) {
        CamelLogger answer = definition.getLoggerBean();
        if (answer == null && definition.getLoggerRef() != null) {
            answer = this.mandatoryLookup(definition.getLoggerRef(), CamelLogger.class);
        }
        if (answer == null) {
            answer = new CamelLogger(LoggerFactory.getLogger(DeadLetterChannel.class), LoggingLevel.ERROR);
        }
        if (definition.getLevel() != null) {
            answer.setLevel(this.parse(LoggingLevel.class, definition.getLevel()));
        }
        return answer;
    }

    private Processor createDeadLetterChannelProcessor(String uri) {
        SendProcessor child = new SendProcessor(this.camelContext.getEndpoint(uri), ExchangePattern.InOnly);
        return new FatalFallbackErrorHandler((Processor)child, true);
    }

    private RedeliveryPolicy resolveRedeliveryPolicy(DeadLetterChannelDefinition definition, CamelContext camelContext) {
        RedeliveryPolicy answer = null;
        RedeliveryPolicyDefinition def = definition.getRedeliveryPolicy();
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            def = this.lookupByNameAndType(definition.getRedeliveryPolicyRef(), RedeliveryPolicyDefinition.class);
        }
        if (def != null) {
            answer = ErrorHandlerReifier.createRedeliveryPolicy(def, camelContext, null);
        }
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            answer = this.mandatoryLookup(definition.getRedeliveryPolicyRef(), RedeliveryPolicy.class);
        }
        if (answer == null) {
            answer = RedeliveryPolicy.DEFAULT_POLICY;
        }
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService(ScheduledExecutorService executorService, String executorServiceRef) {
        if (executorService == null || executorService.isShutdown()) {
            if (executorServiceRef != null) {
                executorService = this.lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorService " + executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = null;
            }
        }
        return executorService;
    }
}

