/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LineNumberAware;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.StringHelper;

public class WireTapReifier
extends ToDynamicReifier<WireTapDefinition<?>> {
    public WireTapReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        ((WireTapDefinition)this.definition).setPattern(ExchangePattern.InOnly.name());
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)this.definition, true);
        ExecutorService threadPool = this.getConfiguredExecutorService("WireTap", (ExecutorServiceAwareDefinition)this.definition, true);
        String uri = ((WireTapDefinition)this.definition).getEndpointProducerBuilder() != null ? ((WireTapDefinition)this.definition).getEndpointProducerBuilder().getRawUri() : StringHelper.notEmpty((String)((WireTapDefinition)this.definition).getUri(), (String)"uri", (Object)this);
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute((NamedNode)this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)uri);
        }
        SendDynamicProcessor dynamicSendProcessor = null;
        SendProcessor sendProcessor = null;
        boolean simple = LanguageSupport.hasSimpleFunction((String)uri);
        boolean dynamic = this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true);
        boolean invalid = this.parseBoolean(((WireTapDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        if (dynamic && simple || invalid) {
            dynamicSendProcessor = (SendDynamicProcessor)super.createProcessor();
        } else {
            Endpoint endpoint = CamelContextHelper.resolveEndpoint((CamelContext)this.camelContext, (String)uri, null);
            LineNumberAware.trySetLineNumberAware((Object)endpoint, (LineNumberAware)this.definition);
            sendProcessor = new SendProcessor(endpoint);
        }
        SendDynamicProcessor producer = dynamicSendProcessor != null ? dynamicSendProcessor : sendProcessor;
        Processor childProcessor = this.wrapInErrorHandler((Processor)producer);
        InternalProcessor target = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        boolean isCopy = this.parseBoolean(((WireTapDefinition)this.definition).getCopy(), true);
        WireTapProcessor answer = new WireTapProcessor(dynamicSendProcessor, (Processor)target, uri, this.parse(ExchangePattern.class, ((WireTapDefinition)this.definition).getPattern()), isCopy, threadPool, shutdownThreadPool, dynamic);
        Processor prepare = ((WireTapDefinition)this.definition).getOnPrepareProcessor();
        if (prepare == null && ((WireTapDefinition)this.definition).getOnPrepare() != null) {
            prepare = this.mandatoryLookup(((WireTapDefinition)this.definition).getOnPrepare(), Processor.class);
        }
        answer.setOnPrepare(prepare);
        return answer;
    }

    @Override
    protected Expression createExpression(String uri) {
        if (this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true)) {
            return super.createExpression(uri);
        }
        return this.camelContext.resolveLanguage("constant").createExpression(uri);
    }
}

