/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.ErrorHandlerRefDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.errorhandler.DeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerRefReifier;
import org.apache.camel.reifier.errorhandler.NoErrorHandlerReifier;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerReifier<T extends ErrorHandlerFactory>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>>> ERROR_HANDLERS = new HashMap(0);
    protected T definition;

    protected ErrorHandlerReifier(Route route, T definition) {
        super(route);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> errorHandlerClass, BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> creator) {
        ERROR_HANDLERS.put(errorHandlerClass, creator);
    }

    public static ErrorHandlerReifier<? extends ErrorHandlerFactory> reifier(Route route, ErrorHandlerFactory definition) {
        BiFunction<Route, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> reifier;
        ErrorHandlerReifier<ErrorHandlerFactory> answer = null;
        if (!ERROR_HANDLERS.isEmpty() && (reifier = ERROR_HANDLERS.get(definition.getClass())) != null) {
            answer = reifier.apply(route, definition);
        }
        if (answer == null) {
            answer = ErrorHandlerReifier.coreReifier(route, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static ErrorHandlerReifier<? extends ErrorHandlerFactory> coreReifier(Route route, ErrorHandlerFactory definition) {
        if (definition instanceof DeadLetterChannelDefinition) {
            return new DeadLetterChannelReifier(route, (DeadLetterChannelDefinition)definition);
        }
        if (definition instanceof DefaultErrorHandlerDefinition) {
            return new DefaultErrorHandlerReifier(route, (DefaultErrorHandlerDefinition)definition);
        }
        if (definition instanceof NoErrorHandlerDefinition) {
            return new NoErrorHandlerReifier(route, definition);
        }
        if (definition instanceof ErrorHandlerRefDefinition) {
            return new ErrorHandlerRefReifier(route, definition);
        }
        return null;
    }

    public ExceptionPolicy createExceptionPolicy(OnExceptionDefinition def) {
        Predicate retryWhile;
        Predicate continued;
        Predicate handled = def.getHandledPolicy();
        if (handled == null && def.getHandled() != null) {
            handled = this.createPredicate(def.getHandled());
        }
        if ((continued = def.getContinuedPolicy()) == null && def.getContinued() != null) {
            continued = this.createPredicate(def.getContinued());
        }
        if ((retryWhile = def.getRetryWhilePolicy()) == null && def.getRetryWhile() != null) {
            retryWhile = this.createPredicate(def.getRetryWhile());
        }
        Processor onRedelivery = this.getProcessor(def.getOnRedelivery(), def.getOnRedeliveryRef());
        Processor onExceptionOccurred = this.getProcessor(def.getOnExceptionOccurred(), def.getOnExceptionOccurredRef());
        return new ExceptionPolicy(def.getId(), CamelContextHelper.getRouteId((NamedNode)def), this.parseBoolean(def.getUseOriginalMessage(), false), this.parseBoolean(def.getUseOriginalBody(), false), ObjectHelper.isNotEmpty((Collection)def.getOutputs()), handled, continued, retryWhile, onRedelivery, onExceptionOccurred, def.getRedeliveryPolicyRef(), ErrorHandlerReifier.createRedeliveryPolicyOptions(def.getRedeliveryPolicyType()), def.getExceptions());
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context) {
        Map<ExceptionPolicy.RedeliveryOption, String> options = ErrorHandlerReifier.createRedeliveryPolicyOptions(definition);
        return ErrorHandlerReifier.createRedeliveryPolicy(options, context, null);
    }

    private static RedeliveryPolicy createRedeliveryPolicy(Map<ExceptionPolicy.RedeliveryOption, String> definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (definition.get(ExceptionPolicy.RedeliveryOption.maximumRedeliveries) != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.maximumRedeliveries)).intValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.redeliveryDelay) != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.redeliveryDelay)).longValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery) != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel) != null) {
                answer.setRetriesExhaustedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.get(ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel)));
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel) != null) {
                answer.setRetryAttemptedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.get(ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel)));
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval) != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval)).intValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.backOffMultiplier) != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.backOffMultiplier)).doubleValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.useExponentialBackOff) != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.useExponentialBackOff)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor) != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor)).doubleValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.useCollisionAvoidance) != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.useCollisionAvoidance)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay) != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay)).longValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logStackTrace) != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logStackTrace)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logRetryStackTrace) != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logRetryStackTrace)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logHandled) != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logHandled)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logNewException) != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logNewException)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logContinued) != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logContinued)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logRetryAttempted) != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logRetryAttempted)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logExhausted) != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logExhausted)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory) != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody) != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody)));
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.disableRedelivery) != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.disableRedelivery)).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.delayPattern) != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.delayPattern)));
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping) != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping)).booleanValue());
            }
            if (definition.get(ExceptionPolicy.RedeliveryOption.exchangeFormatterRef) != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.get(ExceptionPolicy.RedeliveryOption.exchangeFormatterRef)));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    private static Map<ExceptionPolicy.RedeliveryOption, String> createRedeliveryPolicyOptions(RedeliveryPolicyDefinition definition) {
        if (definition == null) {
            return null;
        }
        HashMap<ExceptionPolicy.RedeliveryOption, String> policy = new HashMap<ExceptionPolicy.RedeliveryOption, String>();
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveries, definition.getMaximumRedeliveries());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.redeliveryDelay, definition.getRedeliveryDelay(), "1000");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery, definition.getAsyncDelayedRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.backOffMultiplier, definition.getBackOffMultiplier(), "2");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useExponentialBackOff, definition.getUseExponentialBackOff());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor, definition.getCollisionAvoidanceFactor(), "0.15");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useCollisionAvoidance, definition.getUseCollisionAvoidance());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay, definition.getMaximumRedeliveryDelay(), "60000");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel, definition.getRetriesExhaustedLogLevel(), "ERROR");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel, definition.getRetryAttemptedLogLevel(), "DEBUG");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval, definition.getRetryAttemptedLogInterval(), "1");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryAttempted, definition.getLogRetryAttempted(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logStackTrace, definition.getLogStackTrace(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryStackTrace, definition.getLogRetryStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logHandled, definition.getLogHandled());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logNewException, definition.getLogNewException(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logContinued, definition.getLogContinued());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhausted, definition.getLogExhausted(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory, definition.getLogExhaustedMessageHistory());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody, definition.getLogExhaustedMessageBody());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.disableRedelivery, definition.getDisableRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.delayPattern, definition.getDelayPattern());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping, definition.getAllowRedeliveryWhileStopping(), "true");
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.exchangeFormatterRef, definition.getExchangeFormatterRef());
        return policy;
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value) {
        ErrorHandlerReifier.setOption(policy, option, value, null);
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value, Object defaultValue) {
        if (value != null) {
            policy.put(option, value.toString());
        } else if (defaultValue != null) {
            policy.put(option, defaultValue.toString());
        }
    }

    public void addExceptionPolicy(ErrorHandlerSupport handlerSupport, OnExceptionDefinition exceptionType) {
        Processor errorHandler = this.route.getOnException(exceptionType.getId());
        handlerSupport.addErrorHandler(errorHandler);
        if (ObjectHelper.isNotEmpty((Collection)exceptionType.getExceptions())) {
            List<Class<Throwable>> list = this.createExceptionClasses(exceptionType);
            for (Class<Throwable> clazz : list) {
                String routeId = null;
                if (exceptionType.isRouteScoped()) {
                    routeId = this.route.getRouteId();
                }
                ExpressionDefinition when = exceptionType.getOnWhen() != null ? exceptionType.getOnWhen().getExpression() : null;
                ExceptionPolicyKey key = new ExceptionPolicyKey(routeId, clazz, (Predicate)when);
                ExceptionPolicy policy = this.createExceptionPolicy(exceptionType);
                handlerSupport.addExceptionPolicy(key, policy);
            }
        }
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(OnExceptionDefinition exceptionType) {
        List list = exceptionType.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            try {
                Class type = this.camelContext.getClassResolver().resolveMandatoryClass(name, Throwable.class);
                answer.add(type);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public abstract Processor createErrorHandler(Processor var1) throws Exception;

    public void configure(ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (NamedNode exception : this.route.getErrorHandlers(this.definition)) {
                this.addExceptionPolicy(handlerSupport, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler) {
            boolean original;
            boolean bl = original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy() || ((RedeliveryErrorHandler)handler).isUseOriginalBodyPolicy();
            if (original) {
                this.route.setAllowUseOriginalMessage(Boolean.valueOf(true));
            }
        }
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            Duration duration;
            if (definition.getMaximumRedeliveries() != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaximumRedeliveries()).intValue());
            }
            if (definition.getRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration((CamelContext)context, (String)definition.getRedeliveryDelay());
                answer.setRedeliveryDelay(duration.toMillis());
            }
            if (definition.getAsyncDelayedRedelivery() != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAsyncDelayedRedelivery()).booleanValue());
            }
            if (definition.getRetriesExhaustedLogLevel() != null) {
                answer.setRetriesExhaustedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.getRetriesExhaustedLogLevel()));
            }
            if (definition.getRetryAttemptedLogLevel() != null) {
                answer.setRetryAttemptedLogLevel((LoggingLevel)CamelContextHelper.parse((CamelContext)context, LoggingLevel.class, (String)definition.getRetryAttemptedLogLevel()));
            }
            if (definition.getRetryAttemptedLogInterval() != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getRetryAttemptedLogInterval()).intValue());
            }
            if (definition.getBackOffMultiplier() != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getBackOffMultiplier()).doubleValue());
            }
            if (definition.getUseExponentialBackOff() != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseExponentialBackOff()).booleanValue());
            }
            if (definition.getCollisionAvoidanceFactor() != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getCollisionAvoidanceFactor()).doubleValue());
            }
            if (definition.getUseCollisionAvoidance() != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseCollisionAvoidance()).booleanValue());
            }
            if (definition.getMaximumRedeliveryDelay() != null) {
                duration = CamelContextHelper.parseDuration((CamelContext)context, (String)definition.getMaximumRedeliveryDelay());
                answer.setMaximumRedeliveryDelay(duration.toMillis());
            }
            if (definition.getLogStackTrace() != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogStackTrace()).booleanValue());
            }
            if (definition.getLogRetryStackTrace() != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryStackTrace()).booleanValue());
            }
            if (definition.getLogHandled() != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogHandled()).booleanValue());
            }
            if (definition.getLogNewException() != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogNewException()).booleanValue());
            }
            if (definition.getLogContinued() != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogContinued()).booleanValue());
            }
            if (definition.getLogRetryAttempted() != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryAttempted()).booleanValue());
            }
            if (definition.getLogExhausted() != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhausted()).booleanValue());
            }
            if (definition.getLogExhaustedMessageHistory() != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageHistory()).booleanValue());
            }
            if (definition.getLogExhaustedMessageBody() != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageBody()));
            }
            if (definition.getDisableRedelivery() != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getDisableRedelivery()).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.getDelayPattern() != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.getDelayPattern()));
            }
            if (definition.getAllowRedeliveryWhileStopping() != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowRedeliveryWhileStopping()).booleanValue());
            }
            if (definition.getExchangeFormatterRef() != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.getExchangeFormatterRef()));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected Predicate getPredicate(Predicate pred, String ref) {
        if (pred == null && ref != null) {
            Language bean = this.camelContext.resolveLanguage("bean");
            pred = bean.createPredicate(ref);
        }
        return pred;
    }

    protected <T> T getBean(Class<T> clazz, T bean, String ref) {
        if (bean == null && ref != null) {
            bean = this.lookupByNameAndType(ref, clazz);
        }
        return bean;
    }

    protected Processor getProcessor(Processor processor, String ref) {
        if (processor == null) {
            processor = this.getBean(Processor.class, null, ref);
        }
        if (processor != null) {
            processor = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, processor, this.route);
        }
        return processor;
    }
}

