/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrottlingMode;
import org.apache.camel.processor.ConcurrentRequestsThrottler;
import org.apache.camel.processor.TotalRequestsThrottler;
import org.apache.camel.reifier.ExpressionReifier;

public class ThrottleReifier
extends ExpressionReifier<ThrottleDefinition> {
    public ThrottleReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ThrottleDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean async = this.parseBoolean(((ThrottleDefinition)this.definition).getAsyncDelayed(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)this.definition, true);
        ScheduledExecutorService threadPool = this.getConfiguredScheduledExecutorService("Throttle", (ExecutorServiceAwareDefinition)this.definition, true);
        Expression correlation = null;
        if (((ThrottleDefinition)this.definition).getCorrelationExpression() != null) {
            correlation = this.createExpression(((ThrottleDefinition)this.definition).getCorrelationExpression());
        }
        boolean reject = this.parseBoolean(((ThrottleDefinition)this.definition).getRejectExecution(), false);
        Expression maxRequestsExpression = this.createMaxRequestsPerPeriodExpression();
        if (maxRequestsExpression == null) {
            throw new IllegalArgumentException("MaxRequestsPerPeriod expression must be provided on " + this);
        }
        if (ThrottlingMode.toMode((String)this.parseString(((ThrottleDefinition)this.definition).getMode())) == ThrottlingMode.ConcurrentRequests) {
            ConcurrentRequestsThrottler answer = new ConcurrentRequestsThrottler(this.camelContext, maxRequestsExpression, threadPool, shutdownThreadPool, reject, correlation);
            answer.setAsyncDelayed(async);
            answer.setCallerRunsWhenRejected(this.parseBoolean(((ThrottleDefinition)this.definition).getCallerRunsWhenRejected(), true));
            return answer;
        }
        long period = this.parseDuration(((ThrottleDefinition)this.definition).getTimePeriodMillis(), 1000L);
        TotalRequestsThrottler answer = new TotalRequestsThrottler(this.camelContext, maxRequestsExpression, period, threadPool, shutdownThreadPool, reject, correlation);
        answer.setAsyncDelayed(async);
        answer.setCallerRunsWhenRejected(this.parseBoolean(((ThrottleDefinition)this.definition).getCallerRunsWhenRejected(), true));
        return answer;
    }

    private Expression createMaxRequestsPerPeriodExpression() {
        return ((ThrottleDefinition)this.definition).getExpression() != null ? this.createExpression(((ThrottleDefinition)this.definition).getExpression()) : null;
    }
}

