/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.apache.camel.language.tokenizer.springboot.TokenizeLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@Conditional(value={Condition.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={TokenizeLanguageConfiguration.class})
public class TokenizeLanguageAutoConfiguration {
    @Bean(name={"tokenize-language"})
    @Scope(value="prototype")
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={TokenizeLanguage.class})
    public TokenizeLanguage configureTokenizeLanguage(CamelContext camelContext, TokenizeLanguageConfiguration configuration) throws Exception {
        CamelContextAware contextAware;
        TokenizeLanguage language = new TokenizeLanguage();
        if (CamelContextAware.class.isAssignableFrom(TokenizeLanguage.class) && (contextAware = (CamelContextAware)CamelContextAware.class.cast(language)) != null) {
            contextAware.setCamelContext(camelContext);
        }
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)language, parameters);
        return language;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.language.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.language.tokenize", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.language.tokenize.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

