/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest.springboot;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.springboot.RestConfigurationDefinitionProperties;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnProperty(name={"camel.rest.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={RestConfigurationDefinitionProperties.class})
public class RestConfigurationDefinitionAutoConfiguration {
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private RestConfigurationDefinitionProperties config;

    @Lazy
    @Bean(name={"rest-configuration"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean
    public RestConfiguration configureRestConfigurationDefinition() throws Exception {
        HashMap properties = new HashMap();
        IntrospectionSupport.getProperties((Object)this.config, properties, null, (boolean)false);
        properties.remove("enableCors");
        properties.remove("apiProperty");
        properties.remove("componentProperty");
        properties.remove("consumerProperty");
        properties.remove("dataFormatProperty");
        properties.remove("endpointProperty");
        properties.remove("corsHeaders");
        RestConfiguration definition = new RestConfiguration();
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)definition, properties, (boolean)true);
        definition.setEnableCORS(this.config.getEnableCors().booleanValue());
        if (this.config.getApiProperty() != null) {
            definition.setApiProperties(new HashMap(CollectionHelper.flatternKeysInMap(this.config.getApiProperty(), (String)".")));
        }
        if (this.config.getComponentProperty() != null) {
            definition.setComponentProperties(new HashMap(CollectionHelper.flatternKeysInMap(this.config.getComponentProperty(), (String)".")));
        }
        if (this.config.getConsumerProperty() != null) {
            definition.setConsumerProperties(new HashMap(CollectionHelper.flatternKeysInMap(this.config.getConsumerProperty(), (String)".")));
        }
        if (this.config.getDataFormatProperty() != null) {
            definition.setDataFormatProperties(new HashMap(CollectionHelper.flatternKeysInMap(this.config.getDataFormatProperty(), (String)".")));
        }
        if (this.config.getEndpointProperty() != null) {
            definition.setEndpointProperties(new HashMap(CollectionHelper.flatternKeysInMap(this.config.getEndpointProperty(), (String)".")));
        }
        if (this.config.getCorsHeaders() != null) {
            Map map = CollectionHelper.flatternKeysInMap(this.config.getCorsHeaders(), (String)".");
            HashMap target = new HashMap();
            map.forEach((k, v) -> target.put(k, v.toString()));
            definition.setCorsHeaders(target);
        }
        return definition;
    }
}

