/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.core.xml.AbstractCamelEndpointFactoryBean;
import org.apache.camel.core.xml.AbstractCamelRedeliveryPolicyFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderFunctionDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.core.xml.PatternBasedPackageScanFilter;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.PropertiesDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestContainer;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelContextFactoryBean<T extends ModelCamelContext>
extends IdentifiedType
implements RouteContainer,
RestContainer {
    public static final String LAZY_LOAD_TYPE_CONVERTERS = "CamelLazyLoadTypeConverters";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContextFactoryBean.class);
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private final AtomicBoolean routesSetupDone = new AtomicBoolean();

    public AbstractCamelContextFactoryBean() {
        this.contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    }

    public T getObject() throws Exception {
        return this.getContext();
    }

    public abstract Class<T> getObjectType();

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public void afterPropertiesSet() throws Exception {
        Map map;
        Map lifecycleStrategies;
        Map map2;
        ShutdownStrategy shutdownStrategy;
        Map map3;
        Map eventNotifiers;
        Map typeConverters;
        RuntimeEndpointRegistry runtimeEndpointRegistry;
        UnitOfWorkFactory unitOfWorkFactory;
        EventFactory eventFactory;
        ManagementNamingStrategy managementNamingStrategy;
        ManagementStrategy managementStrategy;
        AsyncProcessorAwaitManager asyncProcessorAwaitManager;
        InflightRepository inflightRepository;
        Delayer delayer;
        HandleFault handleFault;
        BacklogTracer backlogTracer;
        if (ObjectHelper.isEmpty((Object)this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        PackageScanClassResolver packageResolver = this.getBeanForType(PackageScanClassResolver.class);
        if (packageResolver != null) {
            LOG.info("Using custom PackageScanClassResolver: {}", (Object)packageResolver);
            this.getContext().setPackageScanClassResolver(packageResolver);
        }
        if (this.getProperties() != null) {
            this.getContext().setProperties(this.getProperties().asMap());
        }
        this.initLazyLoadTypeConverters();
        this.setupCustomServices();
        this.initCustomRegistry(this.getContext());
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        Tracer tracer = this.getBeanForType(Tracer.class);
        if (tracer != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info("Using custom Tracer: {}", (Object)tracer);
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((backlogTracer = this.getBeanForType(BacklogTracer.class)) != null) {
            LOG.info("Using custom BacklogTracer: {}", (Object)backlogTracer);
            this.getContext().addInterceptStrategy((InterceptStrategy)backlogTracer);
        }
        if ((handleFault = this.getBeanForType(HandleFault.class)) != null) {
            LOG.info("Using custom HandleFault: {}", (Object)handleFault);
            this.getContext().addInterceptStrategy((InterceptStrategy)handleFault);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            LOG.info("Using custom Delayer: {}", (Object)delayer);
            this.getContext().addInterceptStrategy((InterceptStrategy)delayer);
        }
        if ((inflightRepository = this.getBeanForType(InflightRepository.class)) != null) {
            LOG.info("Using custom InflightRepository: {}", (Object)inflightRepository);
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((asyncProcessorAwaitManager = this.getBeanForType(AsyncProcessorAwaitManager.class)) != null) {
            LOG.info("Using custom AsyncProcessorAwaitManager: {}", (Object)asyncProcessorAwaitManager);
            this.getContext().setAsyncProcessorAwaitManager(asyncProcessorAwaitManager);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info("Using custom ManagementStrategy: {}", (Object)managementStrategy);
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((managementNamingStrategy = this.getBeanForType(ManagementNamingStrategy.class)) != null) {
            LOG.info("Using custom ManagementNamingStrategy: {}", (Object)managementNamingStrategy);
            this.getContext().getManagementStrategy().setManagementNamingStrategy(managementNamingStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info("Using custom EventFactory: {}", (Object)eventFactory);
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((unitOfWorkFactory = this.getBeanForType(UnitOfWorkFactory.class)) != null) {
            LOG.info("Using custom UnitOfWorkFactory: {}", (Object)unitOfWorkFactory);
            this.getContext().setUnitOfWorkFactory(unitOfWorkFactory);
        }
        if ((runtimeEndpointRegistry = this.getBeanForType(RuntimeEndpointRegistry.class)) != null) {
            LOG.info("Using custom RuntimeEndpointRegistry: {}", (Object)runtimeEndpointRegistry);
            this.getContext().setRuntimeEndpointRegistry(runtimeEndpointRegistry);
        }
        if ((typeConverters = this.getContext().getRegistry().findByTypeWithName(TypeConverters.class)) != null && !typeConverters.isEmpty()) {
            for (Map.Entry entry : typeConverters.entrySet()) {
                TypeConverters typeConverters2 = (TypeConverters)entry.getValue();
                LOG.info("Adding custom TypeConverters with id: {} and implementation: {}", entry.getKey(), (Object)typeConverters2);
                this.getContext().getTypeConverterRegistry().addTypeConverters(typeConverters2);
            }
        }
        if ((eventNotifiers = this.getContext().getRegistry().findByTypeWithName(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry entry : eventNotifiers.entrySet()) {
                EventNotifier eventNotifier = (EventNotifier)entry.getValue();
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(eventNotifier)) continue;
                LOG.info("Using custom EventNotifier with id: {} and implementation: {}", entry.getKey(), (Object)eventNotifier);
                this.getContext().getManagementStrategy().addEventNotifier(eventNotifier);
            }
        }
        if ((map3 = this.getContext().getRegistry().findByTypeWithName(EndpointStrategy.class)) != null && !map3.isEmpty()) {
            for (Map.Entry entry : map3.entrySet()) {
                EndpointStrategy strategy = (EndpointStrategy)entry.getValue();
                LOG.info("Using custom EndpointStrategy with id: {} and implementation: {}", entry.getKey(), (Object)strategy);
                this.getContext().addRegisterEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info("Using custom ShutdownStrategy: " + shutdownStrategy);
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((map2 = this.getContext().getRegistry().findByTypeWithName(InterceptStrategy.class)) != null && !map2.isEmpty()) {
            for (Map.Entry entry : map2.entrySet()) {
                InterceptStrategy interceptStrategy = (InterceptStrategy)entry.getValue();
                if (this.getContext().getInterceptStrategies().contains(interceptStrategy)) continue;
                LOG.info("Using custom InterceptStrategy with id: {} and implementation: {}", entry.getKey(), (Object)interceptStrategy);
                this.getContext().addInterceptStrategy(interceptStrategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().findByTypeWithName(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy strategy = (LifecycleStrategy)entry.getValue();
                if (this.getContext().getLifecycleStrategies().contains(strategy)) continue;
                LOG.info("Using custom LifecycleStrategy with id: {} and implementation: {}", entry.getKey(), (Object)strategy);
                this.getContext().addLifecycleStrategy(strategy);
            }
        }
        if ((map = this.getContext().getRegistry().findByTypeWithName(RoutePolicyFactory.class)) != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                RoutePolicyFactory factory = (RoutePolicyFactory)entry.getValue();
                LOG.info("Using custom RoutePolicyFactory with id: {} and implementation: {}", entry.getKey(), (Object)factory);
                this.getContext().addRoutePolicyFactory(factory);
            }
        }
        this.initThreadPoolProfiles(this.getContext());
        this.initBeanPostProcessor(this.getContext());
        this.initCamelContext(this.getContext());
        this.initStreamCachingStrategy();
    }

    protected void setupRoutes() throws Exception {
        if (this.routesSetupDone.compareAndSet(false, true)) {
            LOG.debug("Setting up routes");
            this.getContext().setupRoutes(false);
            this.initRouteRefs();
            this.initRestRefs();
            this.getContext().addRestDefinitions(this.getRests());
            for (RestDefinition rest : this.getRests()) {
                List routes = rest.asRouteDefinition(this.getContext());
                for (RouteDefinition route : routes) {
                    this.getRoutes().add(route);
                }
            }
            for (RestConfiguration config : this.getContext().getRestConfigurations()) {
                if (config.getApiContextPath() == null) continue;
                boolean hasRestApi = false;
                for (RouteDefinition route : this.getContext().getRouteDefinitions()) {
                    FromDefinition from = (FromDefinition)route.getInputs().get(0);
                    if (from.getUri() == null || !from.getUri().startsWith("rest-api:")) continue;
                    hasRestApi = true;
                }
                if (hasRestApi) continue;
                RouteDefinition route = RestDefinition.asRouteApiDefinition(this.getContext(), (RestConfiguration)config);
                LOG.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
                this.getRoutes().add(route);
            }
            this.prepareRoutes();
            this.getContext().addRouteDefinitions(this.getRoutes());
            LOG.debug("Found JAXB created routes: {}", this.getRoutes());
            this.findRouteBuilders();
            this.installRoutes();
            this.getContext().setupRoutes(true);
        }
    }

    private void prepareRoutes() {
        for (RouteDefinition route : this.getRoutes()) {
            RouteDefinitionHelper.sanityCheckRoute((RouteDefinition)route);
            RouteDefinitionHelper.prepareRoute(this.getContext(), (RouteDefinition)route, this.getOnExceptions(), this.getIntercepts(), this.getInterceptFroms(), this.getInterceptSendToEndpoints(), this.getOnCompletions());
            route.markPrepared();
        }
    }

    protected abstract void initCustomRegistry(T var1);

    protected void initLazyLoadTypeConverters() {
        if (this.getLazyLoadTypeConverters() != null) {
            this.getContext().setLazyLoadTypeConverters(this.getLazyLoadTypeConverters());
        } else if (System.getProperty(LAZY_LOAD_TYPE_CONVERTERS) != null) {
            String lazy = System.getProperty(LAZY_LOAD_TYPE_CONVERTERS);
            if ("true".equalsIgnoreCase(lazy)) {
                this.getContext().setLazyLoadTypeConverters(Boolean.valueOf(true));
            } else if ("false".equalsIgnoreCase(lazy)) {
                this.getContext().setLazyLoadTypeConverters(Boolean.valueOf(false));
            } else {
                throw new IllegalArgumentException("System property with key CamelLazyLoadTypeConverters has unknown value: " + lazy);
            }
        }
    }

    protected void initJMXAgent() throws Exception {
        CamelJMXAgentDefinition camelJMXAgent = this.getCamelJMXAgent();
        boolean disabled = false;
        if (camelJMXAgent != null) {
            boolean bl = disabled = camelJMXAgent.getDisabled() != null && CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getDisabled()) != false;
        }
        if (disabled) {
            LOG.info("JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
        } else if (camelJMXAgent != null) {
            LOG.info("JMXAgent enabled: {}", (Object)camelJMXAgent);
            DefaultManagementAgent agent = new DefaultManagementAgent(this.getContext());
            if (camelJMXAgent.getConnectorPort() != null) {
                agent.setConnectorPort(CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getConnectorPort()));
            }
            if (camelJMXAgent.getCreateConnector() != null) {
                agent.setCreateConnector(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getCreateConnector()));
            }
            if (camelJMXAgent.getMbeanObjectDomainName() != null) {
                agent.setMBeanObjectDomainName(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getMbeanObjectDomainName()));
            }
            if (camelJMXAgent.getMbeanServerDefaultDomain() != null) {
                agent.setMBeanServerDefaultDomain(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getMbeanServerDefaultDomain()));
            }
            if (camelJMXAgent.getRegistryPort() != null) {
                agent.setRegistryPort(CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getRegistryPort()));
            }
            if (camelJMXAgent.getServiceUrlPath() != null) {
                agent.setServiceUrlPath(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getServiceUrlPath()));
            }
            if (camelJMXAgent.getUsePlatformMBeanServer() != null) {
                agent.setUsePlatformMBeanServer(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getUsePlatformMBeanServer()));
            }
            if (camelJMXAgent.getOnlyRegisterProcessorWithCustomId() != null) {
                agent.setOnlyRegisterProcessorWithCustomId(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            }
            if (camelJMXAgent.getRegisterAlways() != null) {
                agent.setRegisterAlways(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getRegisterAlways()));
            }
            if (camelJMXAgent.getRegisterNewRoutes() != null) {
                agent.setRegisterNewRoutes(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getRegisterNewRoutes()));
            }
            if (camelJMXAgent.getIncludeHostName() != null) {
                agent.setIncludeHostName(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getIncludeHostName()));
            }
            if (camelJMXAgent.getUseHostIPAddress() != null) {
                agent.setUseHostIPAddress(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getUseHostIPAddress()));
            }
            if (camelJMXAgent.getMask() != null) {
                agent.setMask(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getMask()));
            }
            if (camelJMXAgent.getLoadStatisticsEnabled() != null) {
                agent.setLoadStatisticsEnabled(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getLoadStatisticsEnabled()));
            }
            if (camelJMXAgent.getEndpointRuntimeStatisticsEnabled() != null) {
                agent.setEndpointRuntimeStatisticsEnabled(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getEndpointRuntimeStatisticsEnabled()));
            }
            if (camelJMXAgent.getStatisticsLevel() != null) {
                String level = CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getStatisticsLevel());
                ManagementStatisticsLevel msLevel = (ManagementStatisticsLevel)this.getContext().getTypeConverter().mandatoryConvertTo(ManagementStatisticsLevel.class, (Object)level);
                agent.setStatisticsLevel(msLevel);
            }
            ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy(this.getContext(), (ManagementAgent)agent);
            this.getContext().setManagementStrategy((ManagementStrategy)managementStrategy);
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().addLifecycleStrategy((LifecycleStrategy)new DefaultManagementLifecycleStrategy(this.getContext()));
        }
    }

    protected void initStreamCachingStrategy() throws Exception {
        String spoolRules;
        Boolean anySpoolRules;
        Boolean statisticsEnabled;
        Boolean remove;
        String spoolChiper;
        String limit;
        Integer spoolUsedHeap;
        Long spoolThreshold;
        String spoolDirectory;
        CamelStreamCachingStrategyDefinition streamCaching = this.getCamelStreamCachingStrategy();
        if (streamCaching == null) {
            return;
        }
        Boolean enabled = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getEnabled());
        if (enabled != null) {
            this.getContext().getStreamCachingStrategy().setEnabled(enabled.booleanValue());
        }
        if ((spoolDirectory = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolDirectory())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolDirectory(spoolDirectory);
        }
        if ((spoolThreshold = CamelContextHelper.parseLong(this.getContext(), (String)streamCaching.getSpoolThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolThreshold(spoolThreshold.longValue());
        }
        if ((spoolUsedHeap = CamelContextHelper.parseInteger(this.getContext(), (String)streamCaching.getSpoolUsedHeapMemoryThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(spoolUsedHeap.intValue());
        }
        if ((limit = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolUsedHeapMemoryLimit())) != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit ul = (StreamCachingStrategy.SpoolUsedHeapMemoryLimit)CamelContextHelper.mandatoryConvertTo(this.getContext(), StreamCachingStrategy.SpoolUsedHeapMemoryLimit.class, (Object)limit);
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(ul);
        }
        if ((spoolChiper = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolChiper())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolChiper(spoolChiper);
        }
        if ((remove = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getRemoveSpoolDirectoryWhenStopping())) != null) {
            this.getContext().getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(remove.booleanValue());
        }
        if ((statisticsEnabled = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getStatisticsEnabled())) != null) {
            this.getContext().getStreamCachingStrategy().getStatistics().setStatisticsEnabled(statisticsEnabled.booleanValue());
        }
        if ((anySpoolRules = CamelContextHelper.parseBoolean(this.getContext(), (String)streamCaching.getAnySpoolRules())) != null) {
            this.getContext().getStreamCachingStrategy().setAnySpoolRules(anySpoolRules.booleanValue());
        }
        if ((spoolRules = CamelContextHelper.parseText(this.getContext(), (String)streamCaching.getSpoolRules())) != null) {
            Iterator it = ObjectHelper.createIterator((Object)spoolRules);
            while (it.hasNext()) {
                String name = it.next().toString();
                StreamCachingStrategy.SpoolRule rule = (StreamCachingStrategy.SpoolRule)this.getContext().getRegistry().lookupByNameAndType(name, StreamCachingStrategy.SpoolRule.class);
                if (rule == null) continue;
                this.getContext().getStreamCachingStrategy().addSpoolRule(rule);
            }
        }
    }

    protected void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            PropertiesComponent pc = new PropertiesComponent();
            pc.setLocation(def.getLocation());
            pc.setEncoding(def.getEncoding());
            if (def.isCache() != null) {
                pc.setCache(def.isCache().booleanValue());
            }
            if (def.isIgnoreMissingLocation() != null) {
                pc.setIgnoreMissingLocation(def.isIgnoreMissingLocation().booleanValue());
            }
            if (ObjectHelper.isNotEmpty((Object)def.getPropertiesResolverRef())) {
                PropertiesResolver resolver = (PropertiesResolver)CamelContextHelper.mandatoryLookup(this.getContext(), (String)def.getPropertiesResolverRef(), PropertiesResolver.class);
                pc.setPropertiesResolver(resolver);
            }
            if (ObjectHelper.isNotEmpty((Object)def.getPropertiesParserRef())) {
                PropertiesParser parser = (PropertiesParser)CamelContextHelper.mandatoryLookup(this.getContext(), (String)def.getPropertiesParserRef(), PropertiesParser.class);
                pc.setPropertiesParser(parser);
            }
            pc.setPropertyPrefix(def.getPropertyPrefix());
            pc.setPropertySuffix(def.getPropertySuffix());
            if (def.isFallbackToUnaugmentedProperty() != null) {
                pc.setFallbackToUnaugmentedProperty(def.isFallbackToUnaugmentedProperty().booleanValue());
            }
            if (def.getDefaultFallbackEnabled() != null) {
                pc.setDefaultFallbackEnabled(def.getDefaultFallbackEnabled().booleanValue());
            }
            pc.setPrefixToken(def.getPrefixToken());
            pc.setSuffixToken(def.getSuffixToken());
            if (def.getFunctions() != null && !def.getFunctions().isEmpty()) {
                for (CamelPropertyPlaceholderFunctionDefinition function : def.getFunctions()) {
                    String ref = function.getRef();
                    PropertiesFunction pf = (PropertiesFunction)CamelContextHelper.mandatoryLookup(this.getContext(), (String)ref, PropertiesFunction.class);
                    pc.addFunction(pf);
                }
            }
            this.getContext().addComponent("properties", (Component)pc);
        }
    }

    protected void initRouteRefs() throws Exception {
        if (this.getRouteRefs() != null) {
            for (RouteContextRefDefinition ref : this.getRouteRefs()) {
                List defs = ref.lookupRoutes(this.getContext());
                for (RouteDefinition def : defs) {
                    LOG.debug("Adding route from {} -> {}", (Object)ref, (Object)def);
                    this.getRoutes().add(0, def);
                }
            }
        }
    }

    protected void initRestRefs() throws Exception {
        if (this.getRestRefs() != null) {
            for (RestContextRefDefinition ref : this.getRestRefs()) {
                List defs = ref.lookupRests(this.getContext());
                for (RestDefinition def : defs) {
                    LOG.debug("Adding rest from {} -> {}", (Object)ref, (Object)def);
                    this.getRests().add(0, def);
                }
            }
        }
    }

    protected abstract <S> S getBeanForType(Class<S> var1);

    public void destroy() throws Exception {
        this.routesSetupDone.set(false);
        this.getContext().stop();
    }

    public T getContext() {
        return this.getContext(true);
    }

    public abstract T getContext(boolean var1);

    public abstract List<RouteDefinition> getRoutes();

    public abstract List<RestDefinition> getRests();

    public abstract RestConfigurationDefinition getRestConfiguration();

    public abstract List<? extends AbstractCamelEndpointFactoryBean> getEndpoints();

    public abstract List<? extends AbstractCamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies();

    public abstract List<InterceptDefinition> getIntercepts();

    public abstract List<InterceptFromDefinition> getInterceptFroms();

    public abstract List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints();

    public abstract PropertiesDefinition getProperties();

    public abstract String[] getPackages();

    public abstract PackageScanDefinition getPackageScan();

    public abstract void setPackageScan(PackageScanDefinition var1);

    public abstract ContextScanDefinition getContextScan();

    public abstract void setContextScan(ContextScanDefinition var1);

    public abstract CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder();

    public abstract String getTrace();

    public abstract String getMessageHistory();

    public abstract String getLogExhaustedMessageBody();

    public abstract String getStreamCache();

    public abstract String getDelayer();

    public abstract String getHandleFault();

    public abstract String getAutoStartup();

    public abstract String getUseMDCLogging();

    public abstract String getUseBreadcrumb();

    public abstract String getAllowUseOriginalMessage();

    public abstract String getRuntimeEndpointRegistryEnabled();

    public abstract String getManagementNamePattern();

    public abstract String getThreadNamePattern();

    @Deprecated
    public abstract Boolean getLazyLoadTypeConverters();

    public abstract Boolean getTypeConverterStatisticsEnabled();

    public abstract LoggingLevel getTypeConverterExistsLoggingLevel();

    public abstract TypeConverterExists getTypeConverterExists();

    public abstract CamelJMXAgentDefinition getCamelJMXAgent();

    public abstract CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy();

    public abstract List<RouteBuilderDefinition> getBuilderRefs();

    public abstract List<RouteContextRefDefinition> getRouteRefs();

    public abstract List<RestContextRefDefinition> getRestRefs();

    public abstract String getErrorHandlerRef();

    public abstract DataFormatsDefinition getDataFormats();

    public abstract List<OnExceptionDefinition> getOnExceptions();

    public abstract List<OnCompletionDefinition> getOnCompletions();

    public abstract ShutdownRoute getShutdownRoute();

    public abstract ShutdownRunningTask getShutdownRunningTask();

    public abstract List<ThreadPoolProfileDefinition> getThreadPoolProfiles();

    public abstract String getDependsOn();

    protected void initCamelContext(T ctx) throws Exception {
        if (this.getStreamCache() != null) {
            ctx.setStreamCaching(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getStreamCache()));
        }
        if (this.getTrace() != null) {
            ctx.setTracing(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getTrace()));
        }
        if (this.getMessageHistory() != null) {
            ctx.setMessageHistory(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getMessageHistory()));
        }
        if (this.getLogExhaustedMessageBody() != null) {
            ctx.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getLogExhaustedMessageBody()));
        }
        if (this.getDelayer() != null) {
            ctx.setDelayer(CamelContextHelper.parseLong(this.getContext(), (String)this.getDelayer()));
        }
        if (this.getHandleFault() != null) {
            ctx.setHandleFault(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getHandleFault()));
        }
        if (this.getErrorHandlerRef() != null) {
            ctx.setErrorHandlerBuilder((ErrorHandlerFactory)new ErrorHandlerBuilderRef(this.getErrorHandlerRef()));
        }
        if (this.getAutoStartup() != null) {
            ctx.setAutoStartup(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getAutoStartup()));
        }
        if (this.getUseMDCLogging() != null) {
            ctx.setUseMDCLogging(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getUseMDCLogging()));
        }
        if (this.getUseBreadcrumb() != null) {
            ctx.setUseBreadcrumb(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getUseBreadcrumb()));
        }
        if (this.getAllowUseOriginalMessage() != null) {
            ctx.setAllowUseOriginalMessage(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getAllowUseOriginalMessage()));
        }
        if (this.getRuntimeEndpointRegistryEnabled() != null) {
            ctx.getRuntimeEndpointRegistry().setEnabled(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getRuntimeEndpointRegistryEnabled()).booleanValue());
        }
        if (this.getManagementNamePattern() != null) {
            ctx.getManagementNameStrategy().setNamePattern(this.getManagementNamePattern());
        }
        if (this.getThreadNamePattern() != null) {
            ctx.getExecutorServiceManager().setThreadNamePattern(this.getThreadNamePattern());
        }
        if (this.getShutdownRoute() != null) {
            ctx.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.getShutdownRunningTask() != null) {
            ctx.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        if (this.getDataFormats() != null) {
            ctx.setDataFormats(this.getDataFormats().asMap());
        }
        if (this.getTypeConverterStatisticsEnabled() != null) {
            ctx.setTypeConverterStatisticsEnabled(this.getTypeConverterStatisticsEnabled());
        }
        if (this.getTypeConverterExists() != null) {
            ctx.getTypeConverterRegistry().setTypeConverterExists(this.getTypeConverterExists());
        }
        if (this.getTypeConverterExistsLoggingLevel() != null) {
            ctx.getTypeConverterRegistry().setTypeConverterExistsLoggingLevel(this.getTypeConverterExistsLoggingLevel());
        }
        if (this.getRestConfiguration() != null) {
            ctx.setRestConfiguration(this.getRestConfiguration().asRestConfiguration(ctx));
        }
    }

    protected void initThreadPoolProfiles(T context) throws Exception {
        HashSet<Object> defaultIds = new HashSet<Object>();
        Map profiles = context.getRegistry().findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (this.getThreadPoolProfiles() != null && !this.getThreadPoolProfiles().isEmpty()) {
            for (ThreadPoolProfileDefinition definition : this.getThreadPoolProfiles()) {
                if (definition.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)definition.getId(), (Object)definition);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
                    defaultIds.add(definition.getId());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private ThreadPoolProfile asThreadPoolProfile(CamelContext context, ThreadPoolProfileDefinition definition) throws Exception {
        ThreadPoolProfile answer = new ThreadPoolProfile();
        answer.setId(definition.getId());
        answer.setDefaultProfile(definition.getDefaultProfile());
        answer.setPoolSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getPoolSize()));
        answer.setMaxPoolSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaxPoolSize()));
        answer.setKeepAliveTime(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getKeepAliveTime()));
        answer.setMaxQueueSize(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaxQueueSize()));
        answer.setAllowCoreThreadTimeOut(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowCoreThreadTimeOut()));
        answer.setRejectedPolicy(definition.getRejectedPolicy());
        answer.setTimeUnit(definition.getTimeUnit());
        return answer;
    }

    protected abstract void initBeanPostProcessor(T var1);

    protected void installRoutes() throws Exception {
        ArrayList builders = new ArrayList();
        if (this.getBuilderRefs() != null) {
            for (RouteBuilderDefinition builderRef : this.getBuilderRefs()) {
                RoutesBuilder routes = builderRef.createRoutes(this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            this.postProcessBeforeInit(builder);
            this.getContext().addRoutes((RoutesBuilder)builder);
        }
    }

    protected abstract void postProcessBeforeInit(RouteBuilder var1);

    protected void findRouteBuilders() throws Exception {
        ContextScanDefinition contextScanDef;
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : packageScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (Object exclude : packageScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders((String)exclude);
                filter.addExcludePattern((String)exclude);
            }
            String[] normalized = this.normalizePackages(this.getContext(), packageScanDef.getPackages());
            this.findRouteBuildersByPackageScan(normalized, filter, this.builders);
        }
        if ((contextScanDef = this.getContextScan()) != null) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : contextScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : contextScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            boolean includeNonSingletons = contextScanDef.getIncludeNonSingletons() != null ? contextScanDef.getIncludeNonSingletons() : false;
            this.findRouteBuildersByContextScan(filter, includeNonSingletons, this.builders);
        }
    }

    protected abstract void findRouteBuildersByPackageScan(String[] var1, PackageScanFilter var2, List<RoutesBuilder> var3) throws Exception;

    protected abstract void findRouteBuildersByContextScan(PackageScanFilter var1, boolean var2, List<RoutesBuilder> var3) throws Exception;

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(T context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!ObjectHelper.isNotEmpty((Object)(name = ObjectHelper.normalizeClassName((String)name)))) continue;
            LOG.trace("Using package: {} to scan for RouteBuilder classes", (Object)name);
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private void setupCustomServices() {
        MessageHistoryFactory messageHistoryFactory;
        StreamCachingStrategy streamCachingStrategy;
        NodeIdFactory nodeIdFactory;
        UuidGenerator uuidGenerator;
        Debugger debugger;
        ProcessorFactory processorFactory;
        ThreadPoolFactory threadPoolFactory;
        ExecutorServiceManager executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        ModelJAXBContextFactory modelJAXBContextFactory = this.getBeanForType(ModelJAXBContextFactory.class);
        if (modelJAXBContextFactory != null) {
            LOG.info("Using custom ModelJAXBContextFactory: {}", (Object)modelJAXBContextFactory);
            this.getContext().setModelJAXBContextFactory(modelJAXBContextFactory);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info("Using custom ClassResolver: {}", (Object)classResolver);
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info("Using custom FactoryFinderResolver: {}", (Object)factoryFinderResolver);
            this.getContext().setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceManager.class)) != null) {
            LOG.info("Using custom ExecutorServiceStrategy: {}", (Object)executorServiceStrategy);
            this.getContext().setExecutorServiceManager(executorServiceStrategy);
        }
        if ((threadPoolFactory = this.getBeanForType(ThreadPoolFactory.class)) != null) {
            LOG.info("Using custom ThreadPoolFactory: {}", (Object)threadPoolFactory);
            this.getContext().getExecutorServiceManager().setThreadPoolFactory(threadPoolFactory);
        }
        if ((processorFactory = this.getBeanForType(ProcessorFactory.class)) != null) {
            LOG.info("Using custom ProcessorFactory: {}", (Object)processorFactory);
            this.getContext().setProcessorFactory(processorFactory);
        }
        if ((debugger = this.getBeanForType(Debugger.class)) != null) {
            LOG.info("Using custom Debugger: {}", (Object)debugger);
            this.getContext().setDebugger(debugger);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: {}", (Object)uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((nodeIdFactory = this.getBeanForType(NodeIdFactory.class)) != null) {
            LOG.info("Using custom NodeIdFactory: {}", (Object)nodeIdFactory);
            this.getContext().setNodeIdFactory(nodeIdFactory);
        }
        if ((streamCachingStrategy = this.getBeanForType(StreamCachingStrategy.class)) != null) {
            LOG.info("Using custom StreamCachingStrategy: {}", (Object)streamCachingStrategy);
            this.getContext().setStreamCachingStrategy(streamCachingStrategy);
        }
        if ((messageHistoryFactory = this.getBeanForType(MessageHistoryFactory.class)) != null) {
            LOG.info("Using custom MessageHistoryFactory: {}", (Object)messageHistoryFactory);
            this.getContext().setMessageHistoryFactory(messageHistoryFactory);
        }
    }
}

