/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumTypeConverter
implements TypeConverter {
    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        if (type.isEnum() && value != null) {
            String text = value.toString();
            Method method = null;
            try {
                method = type.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeCamelException("Could not find valueOf method on enum type: " + type.getName());
            }
            return (T)ObjectHelper.invokeMethod(method, null, text);
        }
        return null;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, value);
    }
}

