/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.model.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="optionalIdentifiedType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OptionalIdentifiedType<T extends OptionalIdentifiedType> {
    @XmlTransient
    protected static Map<String, AtomicInteger> nodeCounters = new HashMap<String, AtomicInteger>();
    @XmlAttribute(required=false)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    @XmlElement(required=false)
    private Description description;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public String getShortName() {
        return "node";
    }

    public T description(String text) {
        if (this.description == null) {
            this.description = new Description();
        }
        this.description.setText(text);
        return (T)this;
    }

    public T description(String text, String lang) {
        this.description(text);
        this.description.setLang(lang);
        return (T)this;
    }

    public T id(String id) {
        this.setId(id);
        return (T)this;
    }

    public String idOrCreate() {
        if (this.id == null) {
            this.setId(this.createId());
        }
        return this.getId();
    }

    protected String createId() {
        String key = this.getShortName();
        return key + OptionalIdentifiedType.getNodeCounter(key).incrementAndGet();
    }

    protected static synchronized AtomicInteger getNodeCounter(String key) {
        AtomicInteger answer = nodeCounters.get(key);
        if (answer == null) {
            answer = new AtomicInteger(0);
            nodeCounters.put(key, answer);
        }
        return answer;
    }
}

