/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.binding;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.binding.BindingEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ServiceHelper;

public class BindingProducer
extends DefaultProducer {
    private final BindingEndpoint endpoint;
    private final Processor bindingProcessor;
    private final Producer delegateProducer;

    public BindingProducer(BindingEndpoint endpoint) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        this.bindingProcessor = endpoint.getBinding().createProduceProcessor();
        this.delegateProducer = endpoint.getDelegate().createProducer();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.endpoint.pipelineBindingProcessor(this.bindingProcessor, exchange, this.delegateProducer);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.bindingProcessor, this.delegateProducer);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.delegateProducer, this.bindingProcessor);
        super.doStop();
    }
}

