/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;

public final class StringQuoteHelper {
    private StringQuoteHelper() {
    }

    public static String[] splitSafeQuote(String input, char separator) {
        return StringQuoteHelper.splitSafeQuote(input, separator, true);
    }

    public static String[] splitSafeQuote(String input, char separator, boolean trim) {
        if (input == null) {
            return null;
        }
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch == '\'') {
                singleQuoted = !singleQuoted;
                continue;
            }
            if (ch == '\"') {
                doubleQuoted = !doubleQuoted;
                continue;
            }
            if (ch == separator && !singleQuoted && !doubleQuoted && sb.length() > 0) {
                String text = sb.toString();
                if (trim) {
                    text = text.trim();
                }
                answer.add(text);
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            String text = sb.toString();
            if (trim) {
                text = text.trim();
            }
            answer.add(text);
        }
        return answer.toArray(new String[answer.size()]);
    }
}

