/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.List;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;

public interface ManagedTracerBacklogMBean {
    @ManagedAttribute(description="Is tracing enabled")
    public boolean isEnabled();

    @ManagedAttribute(description="Is tracing enabled")
    public void setEnabled(boolean var1);

    @ManagedAttribute(description="Number of maximum traced messages in total to keep in the backlog (FIFO queue)")
    public int getBacklogSize();

    @ManagedAttribute(description="Number of maximum traced messages in total to keep in the backlog (FIFO queue)")
    public void setBacklogSize(int var1);

    @ManagedAttribute(description="Whether to remove traced message from backlog when dumping trace messages")
    public boolean isRemoveOnDump();

    @ManagedAttribute(description="Whether to remove traced message from backlog when dumping trace messages")
    public void setRemoveOnDump(boolean var1);

    @ManagedAttribute(description="To filter tracing by nodes (pattern)")
    public void setTracePattern(String var1);

    @ManagedAttribute(description="To filter tracing by nodes (pattern)")
    public String getTracePattern();

    @ManagedAttribute(description="To filter tracing by predicate (uses simple language by default)")
    public void setTraceFilter(String var1);

    @ManagedAttribute(description="To filter tracing by predicate (uses simple language by default)")
    public String getTraceFilter();

    @ManagedAttribute(description="Number of total traced messages")
    public long getTraceCounter();

    @ManagedOperation(description="Resets the trace counter")
    public void resetTraceCounter();

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public int getBodyMaxChars();

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public void setBodyMaxChars(int var1);

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public boolean isBodyIncludeStreams();

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public void setBodyIncludeStreams(boolean var1);

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public boolean isBodyIncludeFiles();

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public void setBodyIncludeFiles(boolean var1);

    @ManagedOperation(description="Dumps the traced messages for the given node or route")
    public List<BacklogTracerEventMessage> dumpTracedMessages(String var1);

    @ManagedOperation(description="Dumps the traced messages for the given node or route in xml format")
    public String dumpTracedMessagesAsXml(String var1);

    @ManagedOperation(description="Dumps all the traced messages")
    public List<BacklogTracerEventMessage> dumpAllTracedMessages();

    @ManagedOperation(description="Dumps all the traced messages in xml format")
    public String dumpAllTracedMessagesAsXml();

    @ManagedOperation(description="Clears the backlog")
    public void clear();
}

