/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.controlbus.ControlBusComponent;
import org.apache.camel.component.controlbus.ControlBusProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Language;
import org.apache.camel.util.CamelLogger;

public class ControlBusEndpoint
extends DefaultEndpoint {
    private Language language;
    private String routeId;
    private String action;
    private boolean async;
    private LoggingLevel loggingLevel = LoggingLevel.INFO;

    public ControlBusEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public Producer createProducer() throws Exception {
        CamelLogger logger = new CamelLogger(ControlBusProducer.class.getName(), this.loggingLevel);
        return new ControlBusProducer(this, logger);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume from a ControlBusEndpoint: " + this.getEndpointUri());
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public ControlBusComponent getComponent() {
        return (ControlBusComponent)super.getComponent();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }
}

