/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectBlockingProducer;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class DirectEndpoint
extends DefaultEndpoint {
    private volatile Map<String, DirectConsumer> consumers;
    private boolean block;
    private long timeout = 30000L;

    public DirectEndpoint() {
        this.consumers = new HashMap<String, DirectConsumer>();
    }

    public DirectEndpoint(String endpointUri, Component component) {
        this(endpointUri, component, new HashMap<String, DirectConsumer>());
    }

    public DirectEndpoint(String uri, Component component, Map<String, DirectConsumer> consumers) {
        super(uri, component);
        this.consumers = consumers;
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.block) {
            return new DirectBlockingProducer(this);
        }
        return new DirectProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        DirectConsumer answer = new DirectConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public void addConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getKey();
        this.consumers.put(key, consumer);
    }

    public void removeConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getKey();
        this.consumers.remove(key);
    }

    public boolean hasConsumer(DirectConsumer consumer) {
        String key = consumer.getEndpoint().getKey();
        return this.consumers.containsKey(key);
    }

    public DirectConsumer getConsumer() {
        String key = this.getKey();
        return this.consumers.get(key);
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected String getKey() {
        String uri = this.getEndpointUri();
        if (uri.indexOf(63) != -1) {
            return ObjectHelper.before(uri, "?");
        }
        return uri;
    }
}

