/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectVmProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DirectVmProducer.class);
    private DirectVmEndpoint endpoint;

    public DirectVmProducer(DirectVmEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        DirectVmConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            LOG.warn("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange);
            throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
        }
        consumer.getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        DirectVmConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            LOG.warn("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange);
            exchange.setException(new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange));
            callback.done(true);
            return true;
        }
        AsyncProcessor processor = AsyncProcessorConverterHelper.convert(consumer.getProcessor());
        return AsyncProcessorHelper.process(processor, exchange, callback);
    }
}

