/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.camel.util.AntPathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntPathMatcherFileFilter
implements FileFilter {
    private static final transient Logger LOG = LoggerFactory.getLogger(AntPathMatcherFileFilter.class);
    private AntPathMatcher matcher = new AntPathMatcher();
    private String[] excludes;
    private String[] includes;
    private boolean caseSensitive = true;

    @Override
    public boolean accept(File pathname) {
        return this.acceptPathName(pathname.getPath());
    }

    public boolean acceptPathName(String path) {
        path = path.replace(File.separatorChar, '/');
        LOG.trace("Filtering file: {}", (Object)path);
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!this.matcher.match(exclude, path, this.caseSensitive)) continue;
                LOG.trace("File is excluded: {}", (Object)path);
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                if (!this.matcher.match(include, path, this.caseSensitive)) continue;
                LOG.trace("File is included: {}", (Object)path);
                return true;
            }
        }
        return this.excludes != null && this.includes == null;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.setExcludes(excludes.split(","));
    }

    public void setIncludes(String includes) {
        this.setIncludes(includes.split(","));
    }
}

