/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.ServiceHelper;

public class LogEndpoint
extends ProcessorEndpoint {
    private volatile Processor logger;
    private String level;
    private String marker;
    private Integer groupSize;
    private Long groupInterval;
    private Boolean groupActiveOnly;
    private Long groupDelay;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, Processor logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.logger);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.logger);
    }

    public void setLogger(Processor logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    public Processor getLogger() {
        return this.logger;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new LogProducer(this, this.logger);
    }

    @Override
    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        this.groupInterval = groupInterval;
    }

    public Boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    public void setGroupActiveOnly(Boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public Long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(Long groupDelay) {
        this.groupDelay = groupDelay;
    }
}

