/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable,
ShutdownAware,
SuspendableService {
    private static final transient Logger LOG = LoggerFactory.getLogger(SedaConsumer.class);
    private final AtomicInteger taskCount = new AtomicInteger();
    private volatile CountDownLatch latch;
    private volatile boolean shutdownPending;
    private volatile boolean forceShutdown;
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private ExecutorService executor;
    private ExceptionHandler exceptionHandler;
    private final int pollTimeout;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
        this.pollTimeout = endpoint.getPollTimeout();
    }

    public String toString() {
        return "SedaConsumer[" + this.endpoint + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        if (this.endpoint.isPurgeWhenStopping()) {
            this.endpoint.purgeQueue();
        }
        return this.endpoint.getQueue().size();
    }

    @Override
    public void prepareShutdown(boolean forced) {
        this.shutdownPending = true;
        this.forceShutdown = forced;
        if (this.latch != null) {
            LOG.debug("Preparing to shutdown, waiting for {} consumer threads to complete.", (Object)this.latch.getCount());
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isRunAllowed() {
        if (this.forceShutdown) {
            return false;
        }
        if (this.isSuspending() || this.isSuspended()) {
            return true;
        }
        return super.isRunAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.taskCount.incrementAndGet();
        try {
            this.doRun();
        }
        finally {
            this.taskCount.decrementAndGet();
        }
    }

    protected void doRun() {
        BlockingQueue<Exchange> queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            if (this.getEndpoint().getCamelContext().getStatus().isStarting()) {
                LOG.trace("CamelContext is starting so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                }
                continue;
            }
            if (this.isSuspending() || this.isSuspended()) {
                if (this.shutdownPending && queue.isEmpty()) {
                    LOG.trace("Consumer is suspended and shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                    break;
                }
                LOG.trace("Consumer is suspended so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                }
                continue;
            }
            Exchange exchange = null;
            try {
                exchange = queue.poll(this.pollTimeout, TimeUnit.MILLISECONDS);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Polled queue {} with timeout {} ms. -> {}", new Object[]{ObjectHelper.getIdentityHashCode(queue), this.pollTimeout, exchange});
                }
                if (exchange != null) {
                    try {
                        Exchange newExchange = this.prepareExchange(exchange);
                        this.sendToConsumers(newExchange);
                        if (newExchange.hasOut()) {
                            exchange.setOut(newExchange.getOut().copy());
                        } else {
                            exchange.setIn(newExchange.getIn());
                        }
                        if (newExchange.getException() == null) continue;
                        exchange.setException(newExchange.getException());
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                    }
                    catch (Exception e) {
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    }
                    continue;
                }
                if (!this.shutdownPending || !queue.isEmpty()) continue;
                LOG.trace("Shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                break;
            }
            catch (InterruptedException e) {
                LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
            catch (Throwable e) {
                if (exchange != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    continue;
                }
                this.getExceptionHandler().handleException(e);
            }
        }
        this.latch.countDown();
        LOG.debug("Ending this polling consumer thread, there are still {} consumer threads left.", (Object)this.latch.getCount());
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ExchangeHelper.copyExchangeAndSetCamelContext(exchange, this.endpoint.getCamelContext());
        newExchange.setFromEndpoint(this.endpoint);
        return newExchange;
    }

    protected void sendToConsumers(final Exchange exchange) throws Exception {
        int size = this.endpoint.getConsumers().size();
        if (size > 1 && !this.endpoint.isMultipleConsumersSupported()) {
            throw new IllegalStateException("Multiple consumers for the same endpoint is not allowed: " + this.endpoint);
        }
        if (this.endpoint.isMultipleConsumersSupported()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Multicasting to {} consumers for Exchange: {}", (Object)size, (Object)exchange);
            }
            final List<Synchronization> completions = exchange.handoverCompletions();
            MulticastProcessor mp = this.endpoint.getConsumerMulticastProcessor();
            ObjectHelper.notNull(mp, "ConsumerMulticastProcessor", this);
            AsyncProcessorHelper.process(mp, exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    UnitOfWorkHelper.doneSynchronizations(exchange, completions, LOG);
                }
            });
        } else {
            AsyncProcessorHelper.process(this.processor, exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                }
            });
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.latch = new CountDownLatch(this.endpoint.getConcurrentConsumers());
        this.shutdownPending = false;
        this.forceShutdown = false;
        this.setupTasks();
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doSuspend() throws Exception {
        this.endpoint.onStopped(this);
    }

    @Override
    protected void doResume() throws Exception {
        this.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.endpoint.isPurgeWhenStopping()) {
            this.endpoint.purgeQueue();
        }
        this.endpoint.onStopped(this);
        this.shutdownExecutor();
    }

    @Override
    protected void doShutdown() throws Exception {
        this.shutdownExecutor();
    }

    private void shutdownExecutor() {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private void setupTasks() {
        int poolSize = this.endpoint.getConcurrentConsumers();
        if (this.executor == null) {
            this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, this.endpoint.getEndpointUri(), poolSize);
        }
        int tasks = poolSize - this.taskCount.get();
        LOG.debug("Creating {} consumer tasks with poll timeout {} ms.", (Object)tasks, (Object)this.pollTimeout);
        for (int i = 0; i < tasks; ++i) {
            this.executor.execute(this);
        }
    }
}

