/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.Map;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.xml.ResultHandlerFactory;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltComponent
extends DefaultComponent {
    private static final String SAXON_TRANSFORMER_FACTORY_CLASS_NAME = "net.sf.saxon.TransformerFactoryImpl";
    private static final transient Logger LOG = LoggerFactory.getLogger(XsltComponent.class);
    private XmlConverter xmlConverter;
    private URIResolver uriResolver;
    private boolean contentCache = true;
    private boolean saxon;

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isSaxon() {
        return this.saxon;
    }

    public void setSaxon(boolean saxon) {
        this.saxon = saxon;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URIResolver resolver;
        Boolean failOnNullBody;
        ResultHandlerFactory resultHandlerFactory;
        String resourceUri = remaining;
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        XsltBuilder xslt = this.getCamelContext().getInjector().newInstance(XsltBuilder.class);
        XmlConverter converter = this.resolveAndRemoveReferenceParameter(parameters, "converter", XmlConverter.class);
        if (converter == null) {
            converter = this.getXmlConverter();
        }
        if (converter != null) {
            xslt.setConverter(converter);
        }
        String transformerFactoryClassName = this.getAndRemoveParameter(parameters, "transformerFactoryClass", String.class);
        Boolean saxon = this.getAndRemoveParameter(parameters, "saxon", Boolean.class, this.isSaxon());
        if (transformerFactoryClassName == null && saxon.booleanValue()) {
            transformerFactoryClassName = SAXON_TRANSFORMER_FACTORY_CLASS_NAME;
        }
        TransformerFactory factory = null;
        if (transformerFactoryClassName != null) {
            Class<?> factoryClass = this.getCamelContext().getClassResolver().resolveMandatoryClass(transformerFactoryClassName, XsltComponent.class.getClassLoader());
            LOG.debug("Using TransformerFactoryClass {}", factoryClass);
            factory = (TransformerFactory)this.getCamelContext().getInjector().newInstance(factoryClass);
        }
        if (parameters.get("transformerFactory") != null) {
            factory = this.resolveAndRemoveReferenceParameter(parameters, "transformerFactory", TransformerFactory.class);
        }
        if (factory != null) {
            LOG.debug("Using TransformerFactory {}", factory);
            xslt.getConverter().setTransformerFactory(factory);
        }
        if ((resultHandlerFactory = this.resolveAndRemoveReferenceParameter(parameters, "resultHandlerFactory", ResultHandlerFactory.class)) != null) {
            xslt.setResultHandlerFactory(resultHandlerFactory);
        }
        if ((failOnNullBody = this.getAndRemoveParameter(parameters, "failOnNullBody", Boolean.class)) != null) {
            xslt.setFailOnNullBody(failOnNullBody);
        }
        String output = this.getAndRemoveParameter(parameters, "output", String.class);
        this.configureOutput(xslt, output);
        Integer cs = this.getAndRemoveParameter(parameters, "transformerCacheSize", Integer.class, 0);
        xslt.transformerCacheSize(cs);
        boolean cache = this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        if (ResourceHelper.isHttpUri(resourceUri)) {
            resourceUri = ResourceHelper.appendParameters(resourceUri, parameters);
        }
        if ((resolver = this.resolveAndRemoveReferenceParameter(parameters, "uriResolver", URIResolver.class)) == null) {
            resolver = this.getUriResolver();
        }
        if (resolver == null) {
            resolver = new XsltUriResolver(this.getCamelContext().getClassResolver(), remaining);
        }
        xslt.setUriResolver(resolver);
        this.configureXslt(xslt, uri, remaining, parameters);
        return new XsltEndpoint(uri, this, xslt, resourceUri, cache);
    }

    protected void configureXslt(XsltBuilder xslt, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xslt, parameters);
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty(output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }
}

