/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQUuidGenerator
implements UuidGenerator {
    public static final String PROPERTY_IDGENERATOR_PORT = "activemq.idgenerator.port";
    private static final transient Logger LOG = LoggerFactory.getLogger(ActiveMQUuidGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private final AtomicLong sequence = new AtomicLong(1L);
    private final int length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQUuidGenerator(String prefix) {
        String string = UNIQUE_STUB;
        synchronized (string) {
            this.seed = prefix + UNIQUE_STUB + instanceCount++ + "-";
            this.seed = ActiveMQUuidGenerator.generateSanitizedId(this.seed);
            this.length = this.seed.length() + "9223372036854775807".length();
        }
    }

    public ActiveMQUuidGenerator() {
        this("ID-" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    @Override
    public String generateUuid() {
        StringBuilder sb = new StringBuilder(this.length);
        sb.append(this.seed);
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    public String generateSanitizedId() {
        return ActiveMQUuidGenerator.generateSanitizedId(this.generateUuid());
    }

    public static String generateSanitizedId(String id) {
        id = id.replace(':', '-');
        id = id.replace('_', '-');
        id = id.replace('.', '-');
        id = id.replace('/', '-');
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            int idGeneratorPort = 0;
            ServerSocket ss = null;
            try {
                idGeneratorPort = Integer.parseInt(System.getProperty(PROPERTY_IDGENERATOR_PORT, "0"));
                LOG.trace("Using port {}", (Object)idGeneratorPort);
                hostName = InetAddressUtil.getLocalHostName();
                ss = new ServerSocket(idGeneratorPort);
                stub = "-" + ss.getLocalPort() + "-" + System.currentTimeMillis() + "-";
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception ioe) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot generate unique stub by using DNS and binding to local port: " + idGeneratorPort, (Throwable)ioe);
                } else {
                    LOG.warn("Cannot generate unique stub by using DNS and binding to local port: " + idGeneratorPort + " due " + ioe.getMessage());
                }
            }
            finally {
                try {
                    ss.close();
                }
                catch (IOException ioe) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Closing the server socket failed", (Throwable)ioe);
                    }
                    LOG.warn("Closing the server socket failed due " + ioe.getMessage());
                }
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        }
        if (ObjectHelper.isEmpty(stub)) {
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = stub;
    }
}

