/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="redeliveryPolicy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedeliveryPolicyDefinition {
    @XmlAttribute
    private String maximumRedeliveries;
    @XmlAttribute
    private String redeliveryDelay;
    @XmlAttribute
    private String asyncDelayedRedelivery;
    @XmlAttribute
    private String backOffMultiplier;
    @XmlAttribute
    private String useExponentialBackOff;
    @XmlAttribute
    private String collisionAvoidanceFactor;
    @XmlAttribute
    private String useCollisionAvoidance;
    @XmlAttribute
    private String maximumRedeliveryDelay;
    @XmlAttribute
    private LoggingLevel retriesExhaustedLogLevel;
    @XmlAttribute
    private LoggingLevel retryAttemptedLogLevel;
    @XmlAttribute
    private String logRetryAttempted;
    @XmlAttribute
    private String logStackTrace;
    @XmlAttribute
    private String logRetryStackTrace;
    @XmlAttribute
    private String logHandled;
    @XmlAttribute
    private String logContinued;
    @XmlAttribute
    private String logExhausted;
    @XmlAttribute
    private String disableRedelivery;
    @XmlAttribute
    private String delayPattern;
    @XmlAttribute
    private String allowRedeliveryWhileStopping;

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (this.maximumRedeliveries != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger(context, this.maximumRedeliveries));
            }
            if (this.redeliveryDelay != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong(context, this.redeliveryDelay));
            }
            if (this.asyncDelayedRedelivery != null && CamelContextHelper.parseBoolean(context, this.asyncDelayedRedelivery).booleanValue()) {
                answer.asyncDelayedRedelivery();
            }
            if (this.retriesExhaustedLogLevel != null) {
                answer.setRetriesExhaustedLogLevel(this.retriesExhaustedLogLevel);
            }
            if (this.retryAttemptedLogLevel != null) {
                answer.setRetryAttemptedLogLevel(this.retryAttemptedLogLevel);
            }
            if (this.backOffMultiplier != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble(context, this.backOffMultiplier));
            }
            if (this.useExponentialBackOff != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean(context, this.useExponentialBackOff));
            }
            if (this.collisionAvoidanceFactor != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble(context, this.collisionAvoidanceFactor));
            }
            if (this.useCollisionAvoidance != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean(context, this.useCollisionAvoidance));
            }
            if (this.maximumRedeliveryDelay != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong(context, this.maximumRedeliveryDelay));
            }
            if (this.logStackTrace != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean(context, this.logStackTrace));
            }
            if (this.logRetryStackTrace != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean(context, this.logRetryStackTrace));
            }
            if (this.logHandled != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean(context, this.logHandled));
            }
            if (this.logContinued != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean(context, this.logContinued));
            }
            if (this.logRetryAttempted != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean(context, this.logRetryAttempted));
            }
            if (this.logExhausted != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean(context, this.logExhausted));
            }
            if (this.disableRedelivery != null && CamelContextHelper.parseBoolean(context, this.disableRedelivery).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (this.delayPattern != null) {
                answer.setDelayPattern(this.delayPattern);
            }
            if (this.allowRedeliveryWhileStopping != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean(context, this.allowRedeliveryWhileStopping));
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries: " + this.maximumRedeliveries + "]";
    }

    public RedeliveryPolicyDefinition asyncDelayedRedelivery() {
        this.setAsyncDelayedRedelivery("true");
        return this;
    }

    public RedeliveryPolicyDefinition allowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        return this.allowRedeliveryWhileStopping(Boolean.toString(allowRedeliveryWhileStopping));
    }

    public RedeliveryPolicyDefinition allowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.setAllowRedeliveryWhileStopping(allowRedeliveryWhileStopping);
        return this;
    }

    public RedeliveryPolicyDefinition backOffMultiplier(double backOffMultiplier) {
        return this.backOffMultiplier(Double.toString(backOffMultiplier));
    }

    public RedeliveryPolicyDefinition backOffMultiplier(String backOffMultiplier) {
        this.setBackOffMultiplier(backOffMultiplier);
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.setCollisionAvoidanceFactor(Double.toString(collisionAvoidancePercent * 0.01));
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        return this.collisionAvoidanceFactor(Double.toString(collisionAvoidanceFactor));
    }

    public RedeliveryPolicyDefinition collisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.setCollisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public RedeliveryPolicyDefinition redeliveryDelay(long delay) {
        return this.redeliveryDelay(Long.toString(delay));
    }

    public RedeliveryPolicyDefinition redeliveryDelay(String delay) {
        this.setRedeliveryDelay(delay);
        return this;
    }

    public RedeliveryPolicyDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition logStackTrace(boolean logStackTrace) {
        return this.logStackTrace(Boolean.toString(logStackTrace));
    }

    public RedeliveryPolicyDefinition logStackTrace(String logStackTrace) {
        this.setLogStackTrace(logStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        return this.logRetryStackTrace(Boolean.toString(logRetryStackTrace));
    }

    public RedeliveryPolicyDefinition logRetryStackTrace(String logRetryStackTrace) {
        this.setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryAttempted(boolean logRetryAttempted) {
        return this.logRetryAttempted(Boolean.toString(logRetryAttempted));
    }

    public RedeliveryPolicyDefinition logRetryAttempted(String logRetryAttempted) {
        this.setLogRetryAttempted(logRetryAttempted);
        return this;
    }

    public RedeliveryPolicyDefinition logHandled(boolean logHandled) {
        return this.logHandled(Boolean.toString(logHandled));
    }

    public RedeliveryPolicyDefinition logHandled(String logHandled) {
        this.setLogHandled(logHandled);
        return this;
    }

    public RedeliveryPolicyDefinition logContinued(boolean logContinued) {
        return this.logContinued(Boolean.toString(logContinued));
    }

    public RedeliveryPolicyDefinition logContinued(String logContinued) {
        this.setLogContinued(logContinued);
        return this;
    }

    public RedeliveryPolicyDefinition logExhausted(boolean logExhausted) {
        return this.logExhausted(Boolean.toString(logExhausted));
    }

    public RedeliveryPolicyDefinition logExhausted(String logExhausted) {
        this.setLogExhausted(logExhausted);
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveries(int maximumRedeliveries) {
        return this.maximumRedeliveries(Integer.toString(maximumRedeliveries));
    }

    public RedeliveryPolicyDefinition maximumRedeliveries(String maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicyDefinition useCollisionAvoidance() {
        this.setUseCollisionAvoidance("true");
        return this;
    }

    public RedeliveryPolicyDefinition useExponentialBackOff() {
        this.setUseExponentialBackOff("true");
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        return this.maximumRedeliveryDelay(Long.toString(maximumRedeliveryDelay));
    }

    public RedeliveryPolicyDefinition maximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicyDefinition delayPattern(String delayPattern) {
        this.setDelayPattern(delayPattern);
        return this;
    }

    public String getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(String maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(String redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public String getAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public boolean isAsyncDelayedRedelivery(CamelContext context) {
        if (this.getAsyncDelayedRedelivery() == null) {
            return false;
        }
        try {
            return CamelContextHelper.parseBoolean(context, this.getAsyncDelayedRedelivery());
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public void setAsyncDelayedRedelivery(String asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public String getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(String backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public String getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(String useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public String getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(String useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public String getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public String getLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(String logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public String getLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(String logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public String getLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(String logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public String getLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(String logHandled) {
        this.logHandled = logHandled;
    }

    public String getLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(String logContinued) {
        this.logContinued = logContinued;
    }

    public String getLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(String logExhausted) {
        this.logExhausted = logExhausted;
    }

    public String getDisableRedelivery() {
        return this.disableRedelivery;
    }

    public void setDisableRedelivery(String disableRedelivery) {
        this.disableRedelivery = disableRedelivery;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public String getAllowRedeliveryWhileStopping() {
        return this.allowRedeliveryWhileStopping;
    }

    public void setAllowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.allowRedeliveryWhileStopping = allowRedeliveryWhileStopping;
    }
}

