/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.text.NumberFormat;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputLogger
extends ServiceSupport
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(ThroughputLogger.class);
    private final AtomicInteger receivedCounter = new AtomicInteger();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private long groupReceivedCount;
    private boolean groupActiveOnly;
    private Integer groupSize;
    private long groupDelay = 1000L;
    private Long groupInterval;
    private long startTime;
    private long groupStartTime;
    private String action = "Received";
    private CamelContext camelContext;
    private ScheduledExecutorService logSchedulerService;
    private CamelLogger log;
    private String lastLogMessage;
    private double rate;
    private double average;

    public ThroughputLogger(CamelLogger log) {
        this.log = log;
    }

    public ThroughputLogger(CamelLogger log, Integer groupSize) {
        this(log);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(CamelLogger log, CamelContext camelContext, Long groupInterval, Long groupDelay, Boolean groupActiveOnly) {
        this(log);
        this.camelContext = camelContext;
        this.setGroupInterval(groupInterval);
        this.setGroupActiveOnly(groupActiveOnly);
        if (groupDelay != null) {
            this.setGroupDelay(groupDelay);
        }
    }

    @Override
    public void process(Exchange exchange) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        int receivedCount = this.receivedCounter.incrementAndGet();
        if (this.groupSize != null && receivedCount % this.groupSize == 0) {
            this.lastLogMessage = this.createLogMessage(exchange, receivedCount);
            this.log.log(this.lastLogMessage);
        }
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        if (groupSize == null || groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be positive, was: " + groupSize);
        }
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        if (groupInterval == null || groupInterval <= 0L) {
            throw new IllegalArgumentException("groupInterval must be positive, was: " + groupInterval);
        }
        this.groupInterval = groupInterval;
    }

    public long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    private void setGroupActiveOnly(boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void reset() {
        this.startTime = 0L;
        this.receivedCounter.set(0);
        this.groupStartTime = 0L;
        this.groupReceivedCount = 0L;
        this.average = 0.0;
        this.rate = 0.0;
        this.lastLogMessage = null;
    }

    public double getRate() {
        return this.rate;
    }

    public double getAverage() {
        return this.average;
    }

    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public String getLastLogMessage() {
        return this.lastLogMessage;
    }

    @Override
    public void doStart() throws Exception {
        if (this.groupInterval != null) {
            ObjectHelper.notNull(this.camelContext, "CamelContext", this);
            this.logSchedulerService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "ThroughputLogger", 1);
            ScheduledLogTask scheduledLogTask = new ScheduledLogTask();
            LOG.info("Scheduling throughput log to run every " + this.groupInterval + " millis.");
            this.logSchedulerService.scheduleAtFixedRate(scheduledLogTask, this.groupDelay, this.groupInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this.logSchedulerService != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.logSchedulerService);
            this.logSchedulerService = null;
        }
    }

    protected String createLogMessage(Exchange exchange, int receivedCount) {
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        this.rate = this.messagesPerSecond(this.groupSize.intValue(), this.groupStartTime, time);
        this.average = this.messagesPerSecond(receivedCount, this.startTime, time);
        long duration = time - this.groupStartTime;
        this.groupStartTime = time;
        return this.getAction() + ": " + receivedCount + " messages so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
    }

    protected void createGroupIntervalLogMessage() {
        if (this.startTime == 0L) {
            return;
        }
        int receivedCount = this.receivedCounter.get();
        if (this.groupActiveOnly && (long)receivedCount == this.groupReceivedCount) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        long duration = time - this.groupStartTime;
        long currentCount = (long)receivedCount - this.groupReceivedCount;
        this.rate = this.messagesPerSecond(currentCount, this.groupStartTime, time);
        this.average = this.messagesPerSecond(receivedCount, this.startTime, time);
        this.groupStartTime = time;
        this.groupReceivedCount = receivedCount;
        this.lastLogMessage = this.getAction() + ": " + currentCount + " new messages, with total " + receivedCount + " so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
        this.log.log(this.lastLogMessage);
    }

    protected double messagesPerSecond(long messageCount, long startTime, long endTime) {
        double rate = (double)messageCount * 1000.0;
        return rate /= (double)(endTime - startTime);
    }

    private final class ScheduledLogTask
    implements Runnable {
        private ScheduledLogTask() {
        }

        @Override
        public void run() {
            if (!ThroughputLogger.this.camelContext.getStatus().isStarted()) {
                LOG.trace("ThroughputLogger cannot start because CamelContext({}) has not been started yet", (Object)ThroughputLogger.this.camelContext.getName());
                return;
            }
            ThroughputLogger.this.createGroupIntervalLogMessage();
        }
    }
}

