/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleBackwardsCompatibleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PredicateToExpressionAdapter;

public class SimpleLanguage
extends LanguageSupport {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    protected Class<?> resultType;
    protected boolean allowEscape = true;

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isAllowEscape() {
        return this.allowEscape;
    }

    public void setAllowEscape(boolean allowEscape) {
        this.allowEscape = allowEscape;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Predicate createPredicate(String expression) {
        ObjectHelper.notNull(expression, "expression");
        expression = this.loadResource(expression);
        Predicate answer = SimpleBackwardsCompatibleParser.parsePredicate(expression, this.allowEscape);
        if (answer == null) {
            SimplePredicateParser parser = new SimplePredicateParser(expression, this.allowEscape);
            answer = parser.parsePredicate();
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        ObjectHelper.notNull(expression, "expression");
        expression = this.loadResource(expression);
        Expression answer = SimpleBackwardsCompatibleParser.parseExpression(expression, this.allowEscape);
        if (answer == null) {
            SimpleExpressionParser parser = new SimpleExpressionParser(expression, this.allowEscape);
            answer = parser.parseExpression();
        }
        if (this.resultType != null) {
            answer = ExpressionBuilder.convertToExpression(answer, this.resultType);
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SimpleLanguage.expression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        SimpleLanguage answer = new SimpleLanguage();
        answer.setResultType(resultType);
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = answer.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        return answer.createExpression(expression);
    }

    public static Expression expression(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Predicate predicate(String predicate) {
        return SIMPLE.createPredicate(predicate);
    }

    public static void changeFunctionStartToken(String ... startToken) {
        SimpleTokenizer.changeFunctionStartToken(startToken);
    }

    public static void changeFunctionEndToken(String ... endToken) {
        SimpleTokenizer.changeFunctionEndToken(endToken);
    }

    public void setFunctionStartToken(String startToken) {
        SimpleLanguage.changeFunctionStartToken(startToken);
    }

    public void setFunctionEndToken(String endToken) {
        SimpleLanguage.changeFunctionEndToken(endToken);
    }
}

