/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@ManagedResource(description="Managed TimerEndpoint")
@UriEndpoint(scheme="timer", consumerClass=TimerConsumer.class)
public class TimerEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private String timerName;
    @UriParam
    private Date time;
    @UriParam
    private long period = 1000L;
    @UriParam
    private long delay = 1000L;
    @UriParam
    private boolean fixedRate;
    @UriParam
    private boolean daemon = true;
    @UriParam
    private Timer timer;
    @UriParam
    private long repeatCount;

    public TimerEndpoint() {
    }

    public TimerEndpoint(String uri, Component component, String timerName) {
        super(uri, component);
        this.timerName = timerName;
    }

    protected TimerEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public TimerComponent getComponent() {
        return (TimerComponent)super.getComponent();
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        TimerConsumer answer = new TimerConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.setTimer(null);
        super.doStop();
    }

    @Override
    @ManagedAttribute
    public boolean isMultipleConsumersSupported() {
        return true;
    }

    @ManagedAttribute(description="Timer Name")
    public String getTimerName() {
        if (this.timerName == null) {
            this.timerName = this.getEndpointUri();
        }
        return this.timerName;
    }

    @ManagedAttribute(description="Timer Name")
    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    @ManagedAttribute(description="Timer Daemon")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(description="Timer Daemon")
    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @ManagedAttribute(description="Timer Delay")
    public long getDelay() {
        return this.delay;
    }

    @ManagedAttribute(description="Timer Delay")
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public boolean isFixedRate() {
        return this.fixedRate;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @ManagedAttribute(description="Timer Period")
    public long getPeriod() {
        return this.period;
    }

    @ManagedAttribute(description="Timer Period")
    public void setPeriod(long period) {
        this.period = period;
    }

    @ManagedAttribute(description="Repeat Count")
    public long getRepeatCount() {
        return this.repeatCount;
    }

    @ManagedAttribute(description="Repeat Count")
    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    @ManagedAttribute(description="Singleton")
    public boolean isSingleton() {
        return true;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @Override
    @ManagedAttribute(description="Endpoint Uri")
    public String getEndpointUri() {
        return super.getEndpointUri();
    }

    @ManagedAttribute(description="Endpoint State")
    public String getState() {
        return this.getStatus().name();
    }

    public Timer getTimer(TimerConsumer consumer) {
        if (this.timer != null) {
            return this.timer;
        }
        return this.getComponent().getTimer(consumer);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void removeTimer(TimerConsumer consumer) {
        if (this.timer == null) {
            this.getComponent().removeTimer(consumer);
        }
    }
}

