/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.NotificationSender;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.util.MessageHelper;

public final class JMXNotificationTraceEventHandler
implements TraceEventHandler,
NotificationSenderAware {
    private static final int MAX_MESSAGE_LENGTH = 60;
    private final AtomicLong num = new AtomicLong();
    private final Tracer tracer;
    private NotificationSender notificationSender;

    public JMXNotificationTraceEventHandler(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public void traceExchangeOut(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange, Object traceState) throws Exception {
    }

    @Override
    public Object traceExchangeIn(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        return null;
    }

    @Override
    public void traceExchange(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        if (this.notificationSender != null && this.tracer.isJmxTraceNotifications()) {
            String body = MessageHelper.extractBodyForLogging(exchange.getIn(), "", false, true, this.tracer.getTraceBodySize());
            if (body == null) {
                body = "";
            }
            String message = body.substring(0, Math.min(body.length(), 60));
            Map<String, Object> tm = this.createTraceMessage(node, exchange, body);
            Notification notification = new Notification("TraceNotification", exchange.toString(), this.num.getAndIncrement(), System.currentTimeMillis(), message);
            notification.setUserData(tm);
            this.notificationSender.sendNotification(notification);
        }
    }

    private Map<String, Object> createTraceMessage(ProcessorDefinition<?> node, Exchange exchange, String body) {
        HashMap<String, Object> mi = new HashMap<String, Object>();
        mi.put("ExchangeId", exchange.getExchangeId());
        mi.put("EndpointURI", this.getEndpointUri(node));
        mi.put("TimeStamp", new Date(System.currentTimeMillis()));
        mi.put("Body", body);
        Message message = exchange.getIn();
        Map<String, Object> sHeaders = message.getHeaders();
        Map<String, Object> sProperties = exchange.getProperties();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : sHeaders.keySet()) {
            headers.put(key, message.getHeader(key, String.class));
        }
        mi.put("Headers", headers);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : sProperties.keySet()) {
            properties.put(key, exchange.getProperty(key, String.class));
        }
        mi.put("Properties", properties);
        return mi;
    }

    private String getEndpointUri(ProcessorDefinition<?> node) {
        if (node instanceof Traceable) {
            Traceable tr = (Traceable)((Object)node);
            return tr.getTraceLabel();
        }
        return node.getLabel();
    }

    @Override
    public void setNotificationSender(NotificationSender sender) {
        this.notificationSender = sender;
    }
}

