/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.validator.DefaultLSResourceResolver;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.validation.ValidatingProcessor;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;

public class ValidatorComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String resourceUri = remaining;
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext().getClassResolver(), resourceUri);
        byte[] bytes = null;
        try {
            bytes = IOConverter.toBytes(is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        ValidatingProcessor validator = new ValidatingProcessor();
        validator.setSchemaAsByteArray(bytes);
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        this.configureValidator(validator, uri, remaining, parameters);
        validator.loadSchema();
        return new ProcessorEndpoint(uri, this, (Processor)validator);
    }

    protected void configureValidator(ValidatingProcessor validator, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LSResourceResolver resourceResolver = this.resolveAndRemoveReferenceParameter(parameters, "resourceResolver", LSResourceResolver.class);
        if (resourceResolver != null) {
            validator.setResourceResolver(resourceResolver);
        } else {
            validator.setResourceResolver(new DefaultLSResourceResolver(this.getCamelContext(), remaining));
        }
        this.setProperties(validator, parameters);
    }
}

