/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement
@XmlType(name="expression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionDefinition
implements Expression,
Predicate {
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    @XmlValue
    private String expression;
    @XmlAttribute
    private Boolean trim;
    @XmlTransient
    private Predicate predicate;
    @XmlTransient
    private Expression expressionValue;
    @XmlTransient
    private ExpressionDefinition expressionType;

    public ExpressionDefinition() {
    }

    public ExpressionDefinition(String expression) {
        this.expression = expression;
    }

    public ExpressionDefinition(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionDefinition(Expression expression) {
        this.expressionValue = expression;
    }

    public static String getLabel(List<ExpressionDefinition> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionDefinition expression : expressions) {
            buffer.append(expression.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getLanguage() != null) {
            sb.append(this.getLanguage()).append("{");
        }
        if (this.getPredicate() != null) {
            sb.append(this.getPredicate().toString());
        }
        if (this.getExpressionValue() != null) {
            sb.append(this.getExpressionValue().toString());
        }
        if (this.getPredicate() == null && this.getExpressionValue() == null && this.getExpression() != null) {
            sb.append(this.getExpression());
        }
        if (this.getLanguage() != null) {
            sb.append("}");
        }
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        return this.evaluate(exchange, Object.class);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expressionValue == null) {
            this.expressionValue = this.createExpression(exchange.getContext());
        }
        ObjectHelper.notNull(this.expressionValue, "expressionValue");
        return this.expressionValue.evaluate(exchange, type);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        if (!this.matches(exchange)) {
            throw new AssertionError((Object)(text + this.getExpression() + " for exchange: " + exchange));
        }
    }

    @Override
    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange.getContext());
        }
        ObjectHelper.notNull(this.predicate, "predicate");
        return this.predicate.matches(exchange);
    }

    public String getLanguage() {
        return "";
    }

    public final Predicate createPredicate(RouteContext routeContext) {
        return this.createPredicate(routeContext.getCamelContext());
    }

    public Predicate createPredicate(CamelContext camelContext) {
        if (this.predicate == null) {
            if (this.getExpressionType() != null) {
                this.predicate = this.getExpressionType().createPredicate(camelContext);
            } else if (this.getExpressionValue() != null) {
                this.predicate = new ExpressionToPredicateAdapter(this.getExpressionValue());
            } else if (this.getExpression() != null) {
                ObjectHelper.notNull("language", this.getLanguage());
                Language language = camelContext.resolveLanguage(this.getLanguage());
                String exp = this.getExpression();
                if (exp != null && this.isTrim()) {
                    exp = exp.trim();
                }
                this.predicate = language.createPredicate(exp);
                this.configurePredicate(camelContext, this.predicate);
            }
        }
        return this.predicate;
    }

    public final Expression createExpression(RouteContext routeContext) {
        return this.createExpression(routeContext.getCamelContext());
    }

    public Expression createExpression(CamelContext camelContext) {
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                this.setExpressionValue(this.getExpressionType().createExpression(camelContext));
            } else if (this.getExpression() != null) {
                ObjectHelper.notNull("language", this.getLanguage());
                Language language = camelContext.resolveLanguage(this.getLanguage());
                String exp = this.getExpression();
                if (exp != null && this.isTrim()) {
                    exp = exp.trim();
                }
                this.setExpressionValue(language.createExpression(exp));
                this.configureExpression(camelContext, this.getExpressionValue());
            }
        }
        return this.getExpressionValue();
    }

    public String getExpression() {
        return this.expression;
    }

    @Required
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    protected void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public Boolean getTrim() {
        return this.trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }

    public boolean isTrim() {
        return this.trim == null || this.trim != false;
    }

    public String getLabel() {
        Predicate predicate = this.getPredicate();
        if (predicate != null) {
            return predicate.toString();
        }
        Expression expressionValue = this.getExpressionValue();
        if (expressionValue != null) {
            return expressionValue.toString();
        }
        String exp = this.getExpression();
        return exp != null ? exp : "";
    }

    protected void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
    }

    protected void configureExpression(CamelContext camelContext, Expression expression) {
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }
}

