/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.ThrottlerRejectedExecutionException;
import org.apache.camel.util.ObjectHelper;

public class Throttler
extends DelayProcessorSupport
implements Traceable {
    private volatile long maximumRequestsPerPeriod;
    private Expression maxRequestsPerPeriodExpression;
    private AtomicLong timePeriodMillis = new AtomicLong(1000L);
    private volatile TimeSlot slot;
    private boolean rejectExecution;

    public Throttler(CamelContext camelContext, Processor processor, Expression maxRequestsPerPeriodExpression, long timePeriodMillis, ScheduledExecutorService executorService, boolean shutdownExecutorService, boolean rejectExecution) {
        super(camelContext, processor, executorService, shutdownExecutorService);
        this.rejectExecution = rejectExecution;
        ObjectHelper.notNull(maxRequestsPerPeriodExpression, "maxRequestsPerPeriodExpression");
        this.maxRequestsPerPeriodExpression = maxRequestsPerPeriodExpression;
        if (timePeriodMillis <= 0L) {
            throw new IllegalArgumentException("TimePeriodMillis should be a positive number, was: " + timePeriodMillis);
        }
        this.timePeriodMillis.set(timePeriodMillis);
    }

    @Override
    public String toString() {
        return "Throttler[requests: " + this.maxRequestsPerPeriodExpression + " per: " + this.timePeriodMillis + " (ms) to: " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "throttle[" + this.maxRequestsPerPeriodExpression + " per: " + this.timePeriodMillis + "]";
    }

    public void setMaximumRequestsPerPeriodExpression(Expression maxRequestsPerPeriodExpression) {
        this.maxRequestsPerPeriodExpression = maxRequestsPerPeriodExpression;
    }

    public Expression getMaximumRequestsPerPeriodExpression() {
        return this.maxRequestsPerPeriodExpression;
    }

    public long getTimePeriodMillis() {
        return this.timePeriodMillis.get();
    }

    public long getCurrentMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis.set(timePeriodMillis);
    }

    @Override
    protected long calculateDelay(Exchange exchange) {
        Object result = this.maxRequestsPerPeriodExpression.evaluate(exchange, Object.class);
        if (result == null) {
            throw new RuntimeExchangeException("The max requests per period expression was evaluated as null: " + this.maxRequestsPerPeriodExpression, exchange);
        }
        Long longValue = exchange.getContext().getTypeConverter().convertTo(Long.class, result);
        if (longValue != null) {
            if (this.maximumRequestsPerPeriod > 0L && longValue != this.maximumRequestsPerPeriod) {
                this.log.debug("Throttler changed maximum requests per period from {} to {}", (Object)this.maximumRequestsPerPeriod, (Object)longValue);
            }
            if (this.maximumRequestsPerPeriod > longValue) {
                this.slot.capacity = 0L;
            }
            this.maximumRequestsPerPeriod = longValue;
        }
        if (this.maximumRequestsPerPeriod <= 0L) {
            throw new IllegalStateException("The maximumRequestsPerPeriod must be a positive number, was: " + this.maximumRequestsPerPeriod);
        }
        TimeSlot slot = this.nextSlot();
        if (!slot.isActive()) {
            long delay = slot.startTime - this.currentSystemTime();
            return delay;
        }
        return 0L;
    }

    protected synchronized TimeSlot nextSlot() {
        if (this.slot == null) {
            this.slot = new TimeSlot();
        }
        if (this.slot.isFull() || !this.slot.isPast()) {
            this.slot = this.slot.next();
        }
        this.slot.assign();
        return this.slot;
    }

    TimeSlot getSlot() {
        return this.slot;
    }

    public boolean isRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(boolean rejectExecution) {
        this.rejectExecution = rejectExecution;
    }

    @Override
    protected boolean processDelay(Exchange exchange, AsyncCallback callback, long delay) {
        if (this.isRejectExecution() && delay > 0L) {
            exchange.setException(new ThrottlerRejectedExecutionException("Exceed the max request limit!"));
            callback.done(true);
            return true;
        }
        return super.processDelay(exchange, callback, delay);
    }

    protected class TimeSlot {
        private volatile long capacity;
        private final long duration;
        private final long startTime;

        protected TimeSlot() {
            this(System.currentTimeMillis());
        }

        protected TimeSlot(long startTime) {
            this.capacity = Throttler.this.maximumRequestsPerPeriod;
            this.duration = Throttler.this.timePeriodMillis.get();
            this.startTime = startTime;
        }

        protected void assign() {
            --this.capacity;
        }

        protected TimeSlot next() {
            return new TimeSlot(Math.max(System.currentTimeMillis(), this.startTime + this.duration));
        }

        protected boolean isPast() {
            long current = System.currentTimeMillis();
            return current < this.startTime + this.duration;
        }

        protected boolean isActive() {
            long current = System.currentTimeMillis();
            return this.startTime <= current && current < this.startTime + this.duration;
        }

        protected boolean isFull() {
            return this.capacity <= 0L;
        }
    }
}

