/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.naming.Context;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.OutHeaders;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithHeadersAndBodyInject3Test
extends ContextTestSupport {
    private MyBean myBean = new MyBean();

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething")).to("mock:finish");
            }
        };
    }

    public void testInOnly() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:finish");
        end.expectedBodiesReceived(new Object[]{"Hello!"});
        ((ValueBuilder)end.message(0).header("out")).isNull();
        this.sendBody("direct:start", "Test Input");
        this.assertMockEndpointsSatisfied();
        BeanWithHeadersAndBodyInject3Test.assertNotNull((Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        BeanWithHeadersAndBodyInject3Test.assertEquals((Object)"Hello!", (Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
    }

    public void testInOut() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:finish");
        end.expectedBodiesReceived(new Object[]{"Hello!"});
        end.expectedHeaderReceived("out", (Object)123);
        String out = (String)this.template.requestBody("direct:start", (Object)"Test Input", String.class);
        BeanWithHeadersAndBodyInject3Test.assertEquals((String)"Hello!", (String)out);
        this.assertMockEndpointsSatisfied();
        BeanWithHeadersAndBodyInject3Test.assertNotNull((Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        BeanWithHeadersAndBodyInject3Test.assertEquals((Object)"Hello!", (Object)((Exchange)end.getExchanges().get(0)).getIn().getBody());
        BeanWithHeadersAndBodyInject3Test.assertEquals((Object)123, (Object)((Exchange)end.getExchanges().get(0)).getIn().getHeader("out"));
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    public static class MyBean {
        public String doSomething(@Body String body, @Headers Map<?, ?> headers, @OutHeaders Map<String, Object> outHeaders) {
            if (outHeaders != null) {
                outHeaders.put("out", 123);
            }
            return "Hello!";
        }
    }
}

