/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.Collection;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.browse.BrowseEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BrowseTest.class);
    protected Object body1 = "one";
    protected Object body2 = "two";

    public void testListEndpoints() throws Exception {
        this.template.sendBody("browse:foo", this.body1);
        this.template.sendBody("browse:foo", this.body2);
        Collection list = this.context.getEndpoints();
        BrowseTest.assertEquals((String)"number of endpoints", (int)2, (int)list.size());
        for (Endpoint endpoint : list) {
            List exchanges = ((BrowseEndpoint)endpoint).getExchanges();
            LOG.debug(">>>> " + endpoint + " has: " + exchanges);
            BrowseTest.assertEquals((String)("Exchanges received on " + endpoint), (int)2, (int)exchanges.size());
            BrowseTest.assertInMessageBodyEquals((Exchange)exchanges.get(0), this.body1);
            BrowseTest.assertInMessageBodyEquals((Exchange)exchanges.get(1), this.body2);
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("browse:foo").to("browse:bar");
            }
        };
    }
}

