/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.dataset.DataSetComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DataSetComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DataSetComponent comp = (DataSetComponent)this.context.getComponent("dataset", DataSetComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("dataset:foo?minRate=3");
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((Object)"3", (Object)conf.getParameter("minRate"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"preloadSize\": { \"kind\": \"parameter\", \"type\": \"integer\""));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"minRate\": { \"kind\": \"parameter\", \"type\": \"integer\""));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"exchangePattern\": { \"kind\": \"parameter\", \"type\": \"string\", \"javaType\": \"org.apache.camel.ExchangePattern\", \"enum\": [ \"InOnly\", \"RobustInOnly\", \"InOut\", \"InOptionalOut\", \"OutOnly\", \"RobustOutOnly\", \"OutIn\", \"OutOptionalIn\" ]"));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"InOut\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("dataset");
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

