/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanToFileTest
extends ContextTestSupport {
    public void testBeanToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/BeanToFileTest.txt", "Bye World");
        this.template.sendBody("direct:in", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").to("bean:myBean")).setHeader("CamelFileName", (Expression)this.constant("BeanToFileTest.txt"))).to(new String[]{"file://target/?fileExist=Override", "mock:result"});
            }
        };
    }

    public static class MyBean {
        public String doSomething(String input) {
            return "Bye " + input;
        }
    }
}

