/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeBackoffMultiplierTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeBackoffMultiplierTest.deleteDirectory("target/files");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
    }

    public void testBackoffMultiplier() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files/?delete=true&backoffMultiplier=4&backoffIdleThreshold=3").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

