/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class FileConsumerAutoCreateDirectoryTest
extends ContextTestSupport {
    public void testCreateDirectory() throws Exception {
        FileConsumerAutoCreateDirectoryTest.deleteDirectory("target/file/foo");
        Endpoint endpoint = this.context.getEndpoint("file://target/file/foo");
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        consumer.start();
        consumer.stop();
        File dir = new File("target/file/foo");
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be created", (boolean)dir.exists());
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be a directory", (boolean)dir.isDirectory());
    }

    public void testCreateAbsoluteDirectory() throws Exception {
        FileConsumerAutoCreateDirectoryTest.deleteDirectory("target/file/foo");
        String base = new File("").getAbsolutePath() + "/target/file/foo";
        Endpoint endpoint = this.context.getEndpoint("file://" + base);
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        consumer.start();
        consumer.stop();
        File dir = new File(base);
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be created", (boolean)dir.exists());
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be a directory", (boolean)dir.isDirectory());
    }

    public void testDoNotCreateDirectory() throws Exception {
        FileConsumerAutoCreateDirectoryTest.deleteDirectory("target/file/foo");
        Endpoint endpoint = this.context.getEndpoint("file://target/file/foo?autoCreate=false");
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        consumer.start();
        consumer.stop();
        File dir = new File("target/file/foo");
        FileConsumerAutoCreateDirectoryTest.assertFalse((String)"Directory should NOT be created", (boolean)dir.exists());
    }

    public void testAutoCreateDirectoryWithDot() throws Exception {
        FileConsumerAutoCreateDirectoryTest.deleteDirectory("target/file/foo.bar");
        Endpoint endpoint = this.context.getEndpoint("file://target/file/foo.bar?autoCreate=true");
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        consumer.start();
        consumer.stop();
        File dir = new File("target/file/foo.bar");
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be created", (boolean)dir.exists());
        FileConsumerAutoCreateDirectoryTest.assertTrue((String)"Directory should be a directory", (boolean)dir.isDirectory());
    }

    public void testStartingDirectoryMustExistDirectory() throws Exception {
        FileConsumerAutoCreateDirectoryTest.deleteDirectory("target/file/foo");
        Endpoint endpoint = this.context.getEndpoint("file://target/file/foo?autoCreate=false&startingDirectoryMustExist=true");
        try {
            endpoint.createConsumer(new Processor(){

                public void process(Exchange exchange) throws Exception {
                }
            });
            FileConsumerAutoCreateDirectoryTest.fail((String)"Should have thrown an exception");
        }
        catch (FileNotFoundException e) {
            FileConsumerAutoCreateDirectoryTest.assertTrue((boolean)e.getMessage().startsWith("Starting directory does not exist"));
        }
        File dir = new File("target/file/foo");
        FileConsumerAutoCreateDirectoryTest.assertFalse((String)"Directory should NOT be created", (boolean)dir.exists());
    }
}

