/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerDirectoryFilterTest
extends ContextTestSupport {
    private final String fileUrl = "file://target/directoryfilter/?recursive=true&filter=#myFilter";
    private final Set<String> names = new TreeSet<String>();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myFilter", new MyDirectoryFilter());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerDirectoryFilterTest.deleteDirectory("target/directoryfilter");
        super.setUp();
    }

    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/directoryfilter/skipDir/", (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader("file:target/directoryfilter/skipDir2/", (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader("file:target/directoryfilter/okDir/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
        FileConsumerDirectoryFilterTest.assertEquals((int)4, (int)this.names.size());
        ArrayList<String> list = new ArrayList<String>(this.names);
        Collections.sort(list);
        FileConsumerDirectoryFilterTest.assertEquals((String)"okDir", (String)((String)list.get(0)));
        FileConsumerDirectoryFilterTest.assertTrue((String)((String)list.get(0)), (((String)list.get(1)).equals("okDir/hello.txt") || ((String)list.get(1)).equals("okDir\\hello.txt") ? 1 : 0) != 0);
        FileConsumerDirectoryFilterTest.assertEquals((String)"skipDir", (String)((String)list.get(2)));
        FileConsumerDirectoryFilterTest.assertEquals((String)"skipDir2", (String)((String)list.get(3)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/directoryfilter/?recursive=true&filter=#myFilter").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public class MyDirectoryFilter<T>
    implements GenericFileFilter<T> {
        public boolean accept(GenericFile<T> file) {
            FileConsumerDirectoryFilterTest.this.names.add(file.getFileName());
            return !file.isDirectory() || !file.getFileName().startsWith("skip");
        }
    }
}

