/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;

public class FileConsumerMoveFailureOnCompletionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerMoveFailureOnCompletionTest.deleteDirectory("target/failed");
        super.setUp();
    }

    public void testMoveFailedRollbackOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.expectedFileExists("target/failed/error/bye-error.txt", "Kabom");
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/failed", (Object)"Kabom", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testMoveFailedCommitAndFailure() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/failed/.camel/hello.txt", "Hello World");
        mock.expectedFileExists("target/failed/error/bye-error.txt", "Kabom");
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/failed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/failed", (Object)"Kabom", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.from("file://target/failed?moveFailed=error/${file:name.noext}-error.txt").onCompletion().onFailureOnly().to("mock:failed")).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kabom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                }).convertBodyTo(String.class).to("mock:result");
            }
        };
    }
}

