/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;

public class FileProduceGeneratedFileNameTest
extends ContextTestSupport {
    public void testGeneratedFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:a");
        FileEndpoint fileEndpoint = this.resolveMandatoryEndpoint("file://target", FileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        String id = fileEndpoint.getGeneratedFileName(exchange.getIn());
        this.template.send(endpoint, exchange);
        File file = new File("target/" + id);
        FileProduceGeneratedFileNameTest.assertEquals((String)("The generated file should exists: " + file), (boolean)true, (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to("file://target");
            }
        };
    }
}

