/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IOHelper;

public class FileProducerCharsetUTFtoISOConvertBodyToTest
extends ContextTestSupport {
    private byte[] utf;
    private byte[] iso;

    @Override
    protected void setUp() throws Exception {
        this.utf = "ABC\u00e6".getBytes("utf-8");
        this.iso = "ABC\u00e6".getBytes("iso-8859-1");
        FileProducerCharsetUTFtoISOConvertBodyToTest.deleteDirectory("target/charset");
        FileProducerCharsetUTFtoISOConvertBodyToTest.createDirectory("target/charset/input");
        this.log.debug("utf: {}", (Object)new String(this.utf, Charset.forName("utf-8")));
        this.log.debug("iso: {}", (Object)new String(this.iso, Charset.forName("iso-8859-1")));
        for (byte b : this.utf) {
            this.log.debug("utf byte: {}", (Object)b);
        }
        for (byte b : this.iso) {
            this.log.debug("iso byte: {}", (Object)b);
        }
        FileOutputStream fos = new FileOutputStream("target/charset/input/input.txt");
        fos.write(this.utf);
        fos.close();
        super.setUp();
    }

    public void testFileProducerCharsetUTFtoISOConvertBodyTo() throws Exception {
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/charset/output.txt");
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertTrue((String)"File should exist", (boolean)file.exists());
        BufferedInputStream fis = IOHelper.buffered((InputStream)new FileInputStream(file));
        byte[] buffer = new byte[100];
        int len = ((InputStream)fis).read(buffer);
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertTrue((String)("Should read data: " + len), (len != -1 ? 1 : 0) != 0);
        byte[] data = new byte[len];
        System.arraycopy(buffer, 0, data, 0, len);
        ((InputStream)fis).close();
        for (byte b : data) {
            this.log.info("loaded byte: {}", (Object)b);
        }
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertEquals((int)4, (int)data.length);
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertEquals((int)65, (int)data[0]);
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertEquals((int)66, (int)data[1]);
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertEquals((int)67, (int)data[2]);
        FileProducerCharsetUTFtoISOConvertBodyToTest.assertEquals((int)-26, (int)data[3]);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file:target/charset/input?noop=true&charset=utf-8").convertBodyTo(byte[].class, "iso-8859-1")).setProperty("CamelCharsetName", (Expression)this.header("someCharsetHeader"))).to("file:target/charset/?fileName=output.txt");
            }
        };
    }
}

