/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class FilerConsumerPreMoveDoneFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerPreMoveDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Thread.sleep(250L);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"ready");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/done/ready");
        FilerConsumerPreMoveDoneFileNameTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/done?preMove=work/work-${file:name}&doneFileName=ready&initialDelay=0&delay=10").to("mock:result");
            }
        };
    }
}

