/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FilerConsumerShouldSkipDoneFilePrefixTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerShouldSkipDoneFilePrefixTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"done-hello.txt");
        Thread.sleep(250L);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.oneExchangeDone.reset();
        File file = new File("target/done/done-hello.txt");
        FilerConsumerShouldSkipDoneFilePrefixTest.assertTrue((String)("Done file should exist: " + file), (boolean)file.exists());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FilerConsumerShouldSkipDoneFilePrefixTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/done?doneFileName=done-${file:name}&initialDelay=0&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

