/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FromFilePollThirdTimeOkTest
extends ContextTestSupport {
    private static int counter;
    private String body = "Hello World this file will be deleted";

    @Override
    protected void setUp() throws Exception {
        FromFilePollThirdTimeOkTest.deleteDirectory("target/deletefile");
        super.setUp();
    }

    public void testPollFileAndShouldBeDeletedAtThirdPoll() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        this.template.sendBodyAndHeader("file://target/deletefile", (Object)this.body, "CamelFileName", (Object)"hello.txt");
        this.context.startRoute("FromFilePollThirdTimeOkTest");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{this.body});
        this.assertMockEndpointsSatisfied();
        FromFilePollThirdTimeOkTest.assertTrue((boolean)notify.matchesMockWaitTime());
        FromFilePollThirdTimeOkTest.assertEquals((int)3, (int)counter);
        File file = new File("target/deletefile/hello.txt");
        FromFilePollThirdTimeOkTest.assertFalse((String)"The file should have been deleted", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/deletefile?delete=true&initialDelay=0&delay=30").noAutoStartup().routeId("FromFilePollThirdTimeOkTest").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                        if (counter < 3) {
                            File file = new File("target/deletefile/hello.txt");
                            TestCase.assertTrue((String)"The file should NOT have been deleted", (boolean)file.exists());
                            throw new IllegalArgumentException("Forced by unittest");
                        }
                    }
                })).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

