/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFileExclusiveReadLockStrategyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerFileExclusiveReadLockStrategyTest.class);
    private static final int NUMBER_OF_THREADS = 5;
    private AtomicInteger numberOfFilesProcessed = new AtomicInteger(0);

    @Override
    protected void setUp() throws Exception {
        MarkerFileExclusiveReadLockStrategyTest.deleteDirectory("target/marker/");
        MarkerFileExclusiveReadLockStrategyTest.createDirectory("target/marker/in");
        super.setUp();
    }

    public void testMultithreadedLocking() throws Exception {
        int i;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedFileExists("target/marker/out/file1.dat");
        mock.expectedFileExists("target/marker/out/file2.dat");
        this.writeFiles();
        this.assertMockEndpointsSatisfied();
        String content = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/marker/out/file1.dat"));
        String[] lines = content.split(LS);
        for (i = 0; i < 20; ++i) {
            MarkerFileExclusiveReadLockStrategyTest.assertEquals((String)("Line " + i), (String)lines[i]);
        }
        content = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/marker/out/file2.dat"));
        lines = content.split(LS);
        for (i = 0; i < 20; ++i) {
            MarkerFileExclusiveReadLockStrategyTest.assertEquals((String)("Line " + i), (String)lines[i]);
        }
        this.waitUntilCompleted();
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists("target/marker/in/file1.dat.camelLock");
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists("target/marker/in/file2.dat.camelLock");
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists("target/marker/in/file1.dat");
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists("target/marker/in/file2.dat");
        MarkerFileExclusiveReadLockStrategyTest.assertEquals((int)2, (int)this.numberOfFilesProcessed.get());
    }

    private void writeFiles() throws Exception {
        LOG.debug("Writing files...");
        FileOutputStream fos = new FileOutputStream("target/marker/in/file1.dat");
        FileOutputStream fos2 = new FileOutputStream("target/marker/in/file2.dat");
        for (int i = 0; i < 20; ++i) {
            fos.write(("Line " + i + LS).getBytes());
            fos2.write(("Line " + i + LS).getBytes());
            LOG.debug("Writing line " + i);
        }
        fos.flush();
        fos.close();
        fos2.flush();
        fos2.close();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.from("file:target/marker/in?readLock=markerFile").onCompletion().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        MarkerFileExclusiveReadLockStrategyTest.this.numberOfFilesProcessed.addAndGet(1);
                    }
                })).end().threads(5).to(new String[]{"file:target/marker/out", "mock:result"});
            }
        };
    }

    private void waitUntilCompleted() {
        while (this.numberOfFilesProcessed.get() < 2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void assertFileDoesNotExists(String filename) {
        File file = new File(filename);
        MarkerFileExclusiveReadLockStrategyTest.assertFalse((String)("File " + filename + " should not exist, it should have been deleted after being processed"), (boolean)file.exists());
    }
}

