/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLEncoder;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.model.RouteDefinition;

public class LanguageCacheScriptTest
extends ContextTestSupport {
    private LanguageEndpoint endpoint;

    public void testCache() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World", "Camel"});
        this.template.sendBody("direct:start", (Object)"World");
        Expression first = this.endpoint.getExpression();
        this.template.sendBody("direct:start", (Object)"Camel");
        Expression second = this.endpoint.getExpression();
        this.assertMockEndpointsSatisfied();
        LanguageCacheScriptTest.assertSame((Object)first, (Object)second);
        LanguageCacheScriptTest.assertNotNull((Object)first);
        LanguageCacheScriptTest.assertNotNull((Object)second);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                String script = URLEncoder.encode("Hello ${body}", "UTF-8");
                LanguageCacheScriptTest.this.endpoint = (LanguageEndpoint)LanguageCacheScriptTest.this.context.getEndpoint("language:simple:" + script + "?transform=false&cacheScript=true", LanguageEndpoint.class);
                ((RouteDefinition)this.from("direct:start").to((Endpoint)LanguageCacheScriptTest.this.endpoint)).to("mock:result");
            }
        };
    }
}

