/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class MockAsBeanTest
extends ContextTestSupport {
    private MockEndpoint foo = new MockEndpoint("mock:foo");

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)this.foo);
        return jndi;
    }

    public void testMockAsBeanWithWhenAnyExchangeReceived() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.foo.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                String in = (String)exchange.getIn().getBody(String.class);
                exchange.getIn().setBody((Object)("Bye " + in));
            }
        });
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").beanRef("foo")).to("mock:result");
            }
        };
    }

    public void testMockAsBeanWithReplyBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.foo.returnReplyBody(ExpressionBuilder.simpleExpression((String)"Bye ${body}"));
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMockAsBeanWithReplyHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("myHeader", (Object)"Bye World");
        this.foo.returnReplyHeader("myHeader", ExpressionBuilder.simpleExpression((String)"Bye ${body}"));
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }
}

