/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentOnlyUseDefaultValuesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testOnlyDefaults() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("{{foo:mock:foo}}")).to("{{bar:mock:bar}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOneMissing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("{{foo:mock:foo}}")).to("{{bar}}");
            }
        });
        try {
            this.context.start();
            PropertiesComponentOnlyUseDefaultValuesTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException failedToCreateRouteException) {
            // empty catch block
        }
    }

    public void testAllMissing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("{{foo:mock:foo}}")).to("{{bar}}");
            }
        });
        try {
            this.context.start();
            PropertiesComponentOnlyUseDefaultValuesTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException failedToCreateRouteException) {
            // empty catch block
        }
    }
}

