/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileSedaShutdownCompleteAllTasksTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileSedaShutdownCompleteAllTasksTest.deleteDirectory("target/seda");
        super.setUp();
    }

    public void testShutdownCompleteAllTasks() throws Exception {
        String url = "file:target/seda";
        this.template.sendBodyAndHeader("file:target/seda", (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/seda", (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/seda", (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader("file:target/seda", (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader("file:target/seda", (Object)"E", "CamelFileName", (Object)"e.txt");
        this.context.getShutdownStrategy().setTimeout(20L);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/seda").routeId("route1").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).to("log:delay")).delay(1000L).to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").routeId("route2").to("log:bar")).to("mock:bar");
            }
        });
        this.context.start();
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        FileSedaShutdownCompleteAllTasksTest.assertEquals((String)"Should complete all messages", (int)5, (int)bar.getReceivedCounter());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

