/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class SedaWaitForTaskCompleteOnCompletionTest
extends ContextTestSupport {
    private static String done = "";

    public void testAlways() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            SedaWaitForTaskCompleteOnCompletionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SedaWaitForTaskCompleteOnCompletionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SedaWaitForTaskCompleteOnCompletionTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        SedaWaitForTaskCompleteOnCompletionTest.assertEquals((String)"CCCCA", (String)done);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                done = done + "A";
                            }
                        });
                    }
                })).to("seda:foo?waitForTaskToComplete=Always")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        done = done + "B";
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("seda:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        done = done + "C";
                    }
                })).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

