/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.RouteDefinition;

public class XsltDTDTest
extends ContextTestSupport {
    private static final String MESSAGE = "<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///etc//user//test\">]><task><name>&xxe;</name></task>";

    public void testSendingStringMessage() throws Exception {
        this.sendEntityMessage(MESSAGE);
    }

    public void testSendingInputStreamMessage() throws Exception {
        InputStream is = IOConverter.toInputStream((String)MESSAGE, (Exchange)new DefaultExchange((CamelContext)this.context));
        this.sendEntityMessage(is);
    }

    private void sendEntityMessage(Object message) throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.reset();
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start1", message);
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        XsltDTDTest.assertTrue((String)"Get a wrong transformed message", (xml.indexOf("<transformed subject=\"\">") > 0 ? 1 : 0) != 0);
        try {
            endpoint.reset();
            endpoint.expectedMessageCount(1);
            this.template.sendBody("direct:start2", message);
            this.assertMockEndpointsSatisfied();
            list = endpoint.getReceivedExchanges();
            exchange = (Exchange)list.get(0);
            xml = (String)exchange.getIn().getBody(String.class);
            XsltDTDTest.assertTrue((String)"Get a wrong transformed message", (xml.indexOf("<transformed subject=\"\">") > 0 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            XsltDTDTest.assertTrue((String)"Get a wrong exception", (boolean)(ex instanceof CamelExecutionException));
            XsltDTDTest.assertTrue((String)"Get a wrong exception cause", (boolean)(ex.getCause() instanceof TransformerException));
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start1").to("xslt:org/apache/camel/component/xslt/transform_dtd.xsl")).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("xslt:org/apache/camel/component/xslt/transform_dtd.xsl?allowStAX=false")).to("mock:result");
            }
        };
    }
}

