/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class XsltMessageTerminateTest
extends ContextTestSupport {
    public void testXsltTerminate() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0);
        XsltMessageTerminateTest.assertNotNull((Object)out);
        Exception cause = (Exception)out.getProperty("CamelExceptionCaught", Exception.class);
        XsltMessageTerminateTest.assertNotNull((Object)cause);
        Exception warning = (Exception)out.getProperty("CamelXsltWarning", Exception.class);
        XsltMessageTerminateTest.assertNotNull((Object)warning);
        XsltMessageTerminateTest.assertEquals((String)"Error: DOB is an empty string!", (String)warning.getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)((RouteDefinition)this.from("file:src/test/data/?fileName=terminate.xml&noop=true").to("xslt:org/apache/camel/component/xslt/terminate.xsl")).to("log:foo")).to("mock:result");
            }
        };
    }
}

