/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EndpointStrategy;

public class InterceptSendToMockEndpointStrategyTest
extends ContextTestSupport {
    public void testAdvisedMockEndpoints() throws Exception {
        this.context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("direct:foo")).to("log:foo")).to("mock:result");
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:direct:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    public void testAdvisedMockEndpointsWithPattern() throws Exception {
        this.context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy("log*"));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("direct:foo")).to("log:foo")).to("mock:result");
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        InterceptSendToMockEndpointStrategyTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
        InterceptSendToMockEndpointStrategyTest.assertNull((Object)this.context.hasEndpoint("mock:direct:start"));
        InterceptSendToMockEndpointStrategyTest.assertNull((Object)this.context.hasEndpoint("mock:direct:foo"));
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

